/*
 * @(#) $Id: SOAPUtility.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.wss4axis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;


public class SOAPUtility {
	/****************************************************************************
	 * class MyByteArrayOutputStream helps in avoiding a copy of the buffer.
	 * Method getByteArrayInputStream() can access the protected members buf and count
	 * of the base class, thus passing the same buffer to the ByteArrayInputStream.
	 ****************************************************************************/
	private static class MyByteArrayOutputStream extends ByteArrayOutputStream {
		public MyByteArrayOutputStream(){
			super();
		}
		public ByteArrayInputStream getByteArrayInputStream(){
			return new ByteArrayInputStream(buf, 0, count);
		}
	}

	public static Document toDocument(SOAPMessage soapMsg) throws
				ParserConfigurationException, SAXException, SOAPException, IOException {
		MyByteArrayOutputStream baos = new MyByteArrayOutputStream();
		soapMsg.writeTo(baos);
		ByteArrayInputStream bais = baos.getByteArrayInputStream();

      	DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setNamespaceAware(true);
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document doc = db.parse(bais);
		return doc;
	}
/*
	public static Document toDocument(SOAPMessage soapMsg) throws
				TransformerConfigurationException, TransformerException, SOAPException, IOException {
		Source src = soapMsg.getSOAPPart().getContent();
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer = tf.newTransformer();
		DOMResult result = new DOMResult();
		transformer.transform(src, result);
		return (Document)result.getNode();
	}
*/
	public static SOAPMessage toSOAPMessage(Document doc) throws
			TransformerConfigurationException, TransformerException,  SOAPException, IOException {
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer = tf.newTransformer();
		MyByteArrayOutputStream baos = new MyByteArrayOutputStream();
		transformer.transform(new DOMSource(doc), new StreamResult(baos));
		ByteArrayInputStream bais = baos.getByteArrayInputStream();

		MessageFactory mf = MessageFactory.newInstance();
		SOAPMessage soapMsg = mf.createMessage(new MimeHeaders(), bais);
		return soapMsg;
	}
/*
	public static SOAPMessage toSOAPMessage(Document doc) throws
			TransformerConfigurationException, TransformerException,  SOAPException, IOException {
		DOMSource src = new DOMSource(doc);

		MessageFactory mf = MessageFactory.newInstance();
		SOAPMessage soapMsg = mf.createMessage();
		soapMsg.getSOAPPart().setContent(src);
		return soapMsg;
	}
*/
	public static void main(String[] args) throws Exception {
		Document doc = XmlUtility.readXML("soap.xml");
		System.out.println("Document read from file:");
		XmlUtility.writeXML(doc, System.out);
		System.out.println();

		SOAPMessage soapMsg = toSOAPMessage(doc);
		System.out.println("Document converted to SOAPMessage:");
		soapMsg.writeTo(System.out);
		System.out.println();

		doc = toDocument(soapMsg);
		System.out.println("SOAPMessage converted to Document:");
		XmlUtility.writeXML(doc, System.out);
		System.out.println();
	}
}