/*
 * @(#) $Id: WSSSign.java,v 1.1.1.1 2003/10/05 18:39:03 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import com.verisign.xmlsig.Signer;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.SigningKeyFactory;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.messaging.WSSecurity;
import com.verisign.xpath.XPath;

public class WSSSign {
	public static void main(String[] args) throws Exception {
		// Input to signature.
		if (args.length < 1){
			System.out.println("Usage:: java WSSSign <inp-file> [<out-file>]");
			return;
		}
		String datafile = args[0];
		String outfile = "signed.xml";
		if (args.length > 1)
			outfile = args[1];

		// Info to get Signing Key.
		String keystore = "my.keystore";
		String storepass = "changeit";
		String kstype = "JCEKS";
		String alias = "mykey";

		System.out.println("Signing XML data in file \"" + datafile + "\"");
		System.out.println("Using private key in keystore \"" + keystore + "\" ...");

		// Get the private key and corresponding certificate.
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(kstype);
		ks.load(fis, storepass.toCharArray());
		PrivateKey key = (PrivateKey)ks.getKey(alias, storepass.toCharArray());
		X509Certificate cert = (X509Certificate)ks.getCertificate(alias);

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);
		SigningKey sk = SigningKeyFactory.makeSigningKey(key);
		KeyInfo ki = new KeyInfo();
		ki.setCertificate(cert);

		WSSecurity wss = new WSSecurity();
		wss.sign(doc, sk, ki);

		// Write the signed XML file
		XmlUtility.writeXML(doc, new FileOutputStream(outfile));
		System.out.println("... Wrote the output to file: \"" + outfile + "\"");
	}
}