/*
 * @(#) $Id: EchoBean.java,v 1.1.1.1 2003/10/05 18:39:00 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package echo;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EchoBean implements SessionBean {

  private SessionContext ctx;

  public void ejbActivate() {
    System.out.println("EchoBean.ejbActivate called");
  }

  public void ejbRemove() {
    System.out.println("EchoBean.ejbRemove called");
  }

  public void ejbPassivate() {
    System.out.println("EchoBean.ejbPassivate called");
  }

  public void setSessionContext(SessionContext ctx) {
    System.out.println("EchoBean.setSessionContext called");
    this.ctx = ctx;

  }

  public void ejbCreate () throws CreateException {
    System.out.println("EchoBean.ejbCreate called");
  }

  public String echo(String arg) {
	System.out.println("----- BEGIN EchoBean.echo(\"" + arg + "\") ----- ");
	printCallerInfo();
    System.out.println("----- END EchoBean.echo() ----- ");

    return arg;
  }

  public String echo2(String arg) {
	System.out.println("----- BEGIN EchoBean.echo2(\"" + arg + "\") ----- ");
	printCallerInfo();
    System.out.println("----- END EchoBean.echo2() ----- ");

    return arg;
  }

  public String echo3(String arg) {
	System.out.println("----- BEGIN EchoBean.echo3(\"" + arg + "\") ----- ");
	printCallerInfo();
	if (!ctx.isCallerInRole("echomanager"))
		throw new java.security.AccessControlException("Caller not in proper role.");
    System.out.println("----- END EchoBean.echo3() ----- ");

    return arg;
  }

  public String echo4(String arg) {
	System.out.println("----- BEGIN EchoBean.echo4(\"" + arg + "\") -----");
	printCallerInfo();
    System.out.println("----- END EchoBean.echo4() ----- ");

    return arg;
  }

  private void printCallerInfo(){
	java.security.Principal caller = ctx.getCallerPrincipal();
	boolean inRole = ctx.isCallerInRole("echomanager");
    System.out.println("Caller Name: " + caller.getName());
    System.out.println("Caller in role \"echomanager\"? " + inRole);
  }
}








