@echo off
rem check for env. variable JAVA_HOME

set _JAVA_BIN=%JAVA_HOME%\bin
if "%_JAVA_BIN%" == "\bin" goto jdkNotFound

set _JSTK_HOME_=%JSTK_HOME%
if "%_JSTK_HOME_%" == "" goto search

if exist "%_JSTK_HOME_%\license.jstk" goto start
echo File license.jstk not found in JSTK_HOME directory: %JSTK_HOME%
goto eof

:search
rem try the current dir. and the parent dir., in that order, for JSTK_HOME
set _JSTK_HOME_=.
if exist "%_JSTK_HOME_%\license.jstk" goto start

set _JSTK_HOME_=..
if exist "%_JSTK_HOME_%\license.jstk" goto start

echo Unable to determine the home directory for JSTK. Set JSTK_HOME to the proper value.
goto eof

:start
set _CP=

for %%i in (%_JSTK_HOME_%\lib\*.jar) do call %_JSTK_HOME_%\bin\cpappend %%i
for %%i in (%_JSTK_HOME_%\build\*.jar) do call %_JSTK_HOME_%\bin\cpappend %%i

set SERVER_DN="CN=Server, OU=X, O=Y, L=Z, S=XY, C=YZ"
set CLIENT_DN="CN=Client, OU=X, O=Y, L=Z, S=XY, C=YZ"
set STOREINFO=-storepass changeit -storetype JCEKS -keypass changeit
set CASTORETYPE=JCEKS


if "%1" == "" goto printHelp
if "%1" == "ss-certs" goto SelfSignedCerts
if "%1" == "cs-certs" goto CASignedCerts
if "%1" == "server-env" goto ServerEnv
if "%1" == "client-env" goto ClientEnv
goto printHelp

:removeExistingStores
echo.
echo Removing files client.ks, client.ts, server.ks and server.ts ...
echo.
if exist server.ks del server.ks
if exist client.ks del client.ks
if exist server.ts del server.ts
if exist client.ts del client.ts
goto eof1


:SelfSignedCerts
echo This option creates keystore and truststore files using self-signed certs.
call :removeExistingStores


set KEYINFO=-keyalg RSA

echo Creating a server certificate in keystore server.ks, exporting it
echo to a temporary file, and then importing it to client truststore client.ts
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %SERVER_DN% %STOREINFO% -keystore server.ks %KEYINFO%
%java_home%\bin\keytool -export -file temp$.cer %STOREINFO% -keystore server.ks
%java_home%\bin\keytool -import -file temp$.cer %STOREINFO% -keystore client.ts -noprompt

echo Creating a client certificate in keystore client.ks, exporting it
echo to a temporary file, and then importing it to server truststore server.ts
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %CLIENT_DN% %STOREINFO% -keystore client.ks %KEYINFO%
%java_home%\bin\keytool -export -file temp$.cer %STOREINFO% -keystore client.ks
%java_home%\bin\keytool -import -file temp$.cer %STOREINFO% -keystore server.ts -noprompt

del temp$.cer
echo.
echo setup done for using self-signed certificates.


goto eof

:CASignedCerts
echo This option creates keystore and truststore files using CA signed certs.
call :removeExistingStores

if exist .\cadir goto createCASignedCerts
echo.
echo Setting up ca CA directory structure ...
echo.
call %_JSTK_HOME_%\bin\certtool setupca -password changeit -storetype %CASTORETYPE%

:createCASignedCerts
echo Creating a self-signed server certificate in keystore server.ks, generating 
echo a CSR, issuing a CA-signed certificate and importing this certificate to
echo server.ks.
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %SERVER_DN% %STOREINFO% -keystore server.ks
%java_home%\bin\keytool -certreq -file temp$.csr %STOREINFO% -keystore server.ks
call %_JSTK_HOME_%\bin\certtool issue -csrfile temp$.csr -cerfile server.cer -password changeit
%java_home%\bin\keytool -import -file server.cer %STOREINFO% -keystore server.ks -noprompt

echo Creating a self-signed server certificate in keystore client.ks, generating 
echo a CSR, issuing a CA-signed certificate and importing this certificate to
echo client.ks.
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %CLIENT_DN% %STOREINFO% -keystore client.ks
%java_home%\bin\keytool -certreq -file temp$.csr %STOREINFO% -keystore client.ks
call %_JSTK_HOME_%\bin\certtool issue -csrfile temp$.csr -cerfile client.cer -password changeit
%java_home%\bin\keytool -import -file client.cer %STOREINFO% -keystore client.ks -noprompt

del server.cer
del client.cer
del temp$.csr

echo Exporting the CA certificate and importing it in server and client truststore
call %_JSTK_HOME_%\bin\certtool exportca -cerfile ca.cer -password changeit
%java_home%\bin\keytool -import -file ca.cer %STOREINFO% -keystore client.ts -noprompt
%java_home%\bin\keytool -import -file ca.cer %STOREINFO% -keystore server.ts -noprompt

del ca.cer
echo.
echo setup done for using CA-signed certificates.


goto eof

:ServerEnv
echo This option sets JSTK_OPTS for running "ssltool server -inproto SSL ..."
echo.
set JSTK_OPTS=%2 -Djavax.net.ssl.keyStore=server.ks -Djavax.net.ssl.keyStoreType=JCEKS -Djavax.net.ssl.keyStorePassword=changeit -Djavax.net.ssl.trustStore=server.ts -Djavax.net.ssl.trustStoreType=JCEKS
echo setup done for keystore and truststore. JSTK_OPTS set to:
echo %JSTK_OPTS%
goto eof

:ClientEnv
echo This option sets JSTK_OPTS for running "ssltool client -outproto SSL ..."
echo.
set JSTK_OPTS=%2 -Djavax.net.ssl.keyStore=client.ks -Djavax.net.ssl.keyStoreType=JCEKS -Djavax.net.ssl.keyStorePassword=changeit -Djavax.net.ssl.trustStore=client.ts -Djavax.net.ssl.trustStoreType=JCEKS
echo setup done for keystore and truststore. JSTK_OPTS set to:
echo %JSTK_OPTS%
goto eof

:printHelp
echo Usage :: sslsetup ^<arg1^> [^<arg2^>]
echo.
echo Where ^<arg1^> is one of:
echo     ss-certs : keystore and truststore with self signed certs.
echo     cs-certs : keystore with CA signed certs and truststore with CA cert.
echo     server-env : JSTK_OPTS env. variable for server.
echo     client-env : JSTK_OPTS env. variable for client.
echo.
echo ^<arg2^> becomes the first field of JSTK_OPTS value when ^<arg1^> is either
echo server-env or client-env. Useful for debugging by passing 
echo "-Djavax.net.debug=ssl" as ^<arg2^>. Do not forget the double quotes.
echo.
echo This program removes existing files client.ks, client.ts, server.ks 
echo and server.ts from the current diretory and creates new ones for
echo ss-certs and cs-certs options.
goto eof

:jdkNotFound
echo You must have JAVA_HOME set to your JDK Installation directory.

:eof
set _JSTK_HOME_=
set _JAVA_BIN=
set _CP=
:eof1
