package server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.BankIntf;
import common.RemoteBank;
import common.RemoteAccount;
import common.RemoteIterator;

public class RemoteBankImpl extends UnicastRemoteObject implements RemoteBank {
	private BankIntf bi;
	private RMIClientSocketFactory clientFactory = null;
	private RMIServerSocketFactory serverFactory = null;;
	private int port = 0;
	public RemoteBankImpl(BankIntf bi) throws RemoteException {
		this.bi = bi;
	}
    public RemoteBankImpl(BankIntf bi, int port,
    		RMIClientSocketFactory clientFactory,
    		RMIServerSocketFactory serverFactory) throws java.rmi.RemoteException {
		super(port, clientFactory, serverFactory);
		this.bi = bi;
		this.clientFactory = clientFactory;
		this.serverFactory = serverFactory;
		this.port = port;
    }
	public RemoteAccount openAccount(BigDecimal initialDeposit) throws RemoteException {
		return new RemoteAccountImpl(bi.openAccount(initialDeposit), port, clientFactory, serverFactory);
	}
	public void closeAccount(String acctNo) throws Exceptions.AccountNotFound,
			Exceptions.AccountClosed, RemoteException {
		bi.closeAccount(acctNo);
	}
	public RemoteAccount getAccount(String acctNo) throws Exceptions.AccountNotFound, RemoteException {
		return new RemoteAccountImpl(bi.getAccount(acctNo), port, clientFactory, serverFactory);
	}
	public RemoteIterator accounts() throws RemoteException {
		return new RemoteIteratorImpl(bi, port, clientFactory, serverFactory);
	}
}
