package client;

import java.io.InputStreamReader;
import java.io.BufferedReader;
import common.RemoteBank;
import java.rmi.Naming;

import org.jstk.example.bank.client.BankClient;

public class RMIBCShell {
    public static void main(String[] args) throws Exception {
		BankClient bc = new BankClient();
		RemoteBank rbank = (RemoteBank)Naming.lookup("rmi://" + args[0] + "/" + "MyRemoteBank");
		bc.init(new BankProxy(rbank));
		while (true){
			System.out.print("rbcsh>");
			System.out.flush();
			String cmdline = new BufferedReader(new InputStreamReader(System.in)).readLine();
			String[] cmdargs = cmdline.split("\\s");

			String result = bc.execCommand(cmdargs);
			System.out.println(result);
		}
	}
}