/*
 * @(#) $Id: RemoteBankImpl.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.BankIntf;
import common.RemoteBank;
import common.RemoteAccount;
import common.RemoteIterator;

public class RemoteBankImpl extends UnicastRemoteObject implements RemoteBank {
	private BankIntf bi;
	public RemoteBankImpl(BankIntf bi) throws RemoteException {
		this.bi = bi;
	}
	public RemoteAccount openAccount(BigDecimal initialDeposit) throws RemoteException {
		return new RemoteAccountImpl(bi.openAccount(initialDeposit));
	}
	public void closeAccount(String acctNo) throws Exceptions.AccountNotFound,
			Exceptions.AccountClosed, RemoteException {
		bi.closeAccount(acctNo);
	}
	public RemoteAccount getAccount(String acctNo) throws Exceptions.AccountNotFound, RemoteException {
		return new RemoteAccountImpl(bi.getAccount(acctNo));
	}
	public RemoteIterator accounts() throws RemoteException {
		return new RemoteIteratorImpl(bi);
	}
}
