/*
 * @(#) $Id: RemoteAccount.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package common;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;

public interface RemoteAccount extends Remote {
	public void deposit(BigDecimal amt) throws Exceptions.AccountClosed, RemoteException;
	public void withdraw(BigDecimal amt) throws Exceptions.AccountClosed,
		Exceptions.InsufficientAmount, RemoteException;
	public void close() throws Exceptions.AccountClosed, RemoteException;
	public BigDecimal getBalance() throws Exceptions.AccountClosed, RemoteException;
	public String getAcctNo() throws RemoteException;
	public String getStatement() throws RemoteException;
}
