/*
 * @(#) $Id: VerifySignature.java,v 1.1.1.1 2003/10/05 18:39:07 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import org.w3c.dom.Document;

import com.verisign.xmlsig.Verifier;
import com.verisign.xpath.XPath;

public class VerifySignature {
	public static void main(String[] args) throws Exception {
		// Input to signature verification
		String sigfile = "sig.xml";
		System.out.println("Verifying signature in file \"" + sigfile + "\"");

		// Read the XML file
      	Document doc = XmlUtility.readXML(sigfile);

		String ns[] = {"ds", "http://www.w3.org/2000/09/xmldsig#"};
		XPath signatureLocation = new XPath("//ds:Signature", ns);
		Verifier verifier = new Verifier(doc, signatureLocation);
		boolean isVerified = verifier.verify();

		System.out.println();
		System.out.println("Signature Verification " + (isVerified ? "SUCCESSFUL!!":"FAILED!!"));
	}
}