/*
 * @(#) $Id: WSSUtility.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.wss4axis;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.KeyGenerator;
import java.security.cert.X509Certificate;

import org.w3c.dom.Document;

import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.SigningKeyFactory;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.messaging.WSSecurity;
import com.verisign.xmlenc.AlgorithmType;
import org.xmltrustcenter.verifier.TrustVerifier;
import org.xmltrustcenter.verifier.X509TrustVerifier;
import com.verisign.messaging.MessageValidity;

public class WSSUtility {
	public static void sign(Document doc, String keystore, String storetype,
						String storepass, String alias, String keypass) throws Exception {
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(storetype);
		ks.load(fis, storepass.toCharArray());
		PrivateKey key = (PrivateKey)ks.getKey(alias, keypass.toCharArray());
		X509Certificate cert = (X509Certificate)ks.getCertificate(alias);

		SigningKey sk = SigningKeyFactory.makeSigningKey(key);
		KeyInfo ki = new KeyInfo();
		ki.setCertificate(cert);

		WSSecurity wss = new WSSecurity();
		wss.sign(doc, sk, ki);
	}

	public static boolean verify(Document doc, String keystore, String storetype,
						String storepass) throws Exception {
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(storetype);
		ks.load(fis, storepass.toCharArray());

		TrustVerifier verifier = new X509TrustVerifier(ks);

		WSSecurity wss = new WSSecurity();
		MessageValidity[] resa = wss.verify(doc, verifier, null);
		if (resa.length > 0)
			return resa[0].isValid();
		return false;
	}

	public static void encrypt(Document doc, String keystore, String storetype,
						String storepass, String alias) throws Exception {
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(storetype);
		ks.load(fis, storepass.toCharArray());
		X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
		PublicKey pubk = cert.getPublicKey();

		KeyGenerator kg = KeyGenerator.getInstance("DESede");
		kg.init(112, new SecureRandom());
		SecretKey key = kg.generateKey();

		KeyInfo ki = new KeyInfo();
		ki.setCertificate(cert);

		WSSecurity wss = new WSSecurity();
		wss.encrypt(doc, key, AlgorithmType.TRIPLEDES, pubk, AlgorithmType.RSA1_5, ki);
	}

	public static void decrypt(Document doc, String keystore, String storetype,
						String storepass, String alias, String keypass) throws Exception {
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(storetype);
		ks.load(fis, storepass.toCharArray());
		PrivateKey prvk2 = (PrivateKey)ks.getKey(alias, keypass.toCharArray());

		WSSecurity wss = new WSSecurity();
		wss.decrypt(doc, prvk2, null);
		WSSecurityExtn.removeWSSEncryptedKey(doc);
	}

	public static void cleanup(Document doc) throws Exception {
		WSSecurityExtn.removeWSSInfo(doc);
	}

	public static void main(String[] unused) throws Exception {
		String datafile = "soap.xml";

		Document doc = XmlUtility.readXML(datafile);

		System.out.println("Input Document:");
		XmlUtility.writeXML(doc, System.out);

		sign(doc, "client.ks", "JCEKS", "changeit", "mykey", "clientpass");
		encrypt(doc, "client.ks", "JCEKS", "changeit", "serverkey");

		System.out.println();
		System.out.println("Signed and Encrypted Document:");
		XmlUtility.writeXML(doc, System.out);

		decrypt(doc, "server.ks", "JCEKS", "changeit", "mykey", "serverpass");
		boolean verified = verify(doc, "server.ks", "JCEKS", "changeit");
		cleanup(doc);

		System.out.println();
		if (!verified){
			System.out.println("Verification failed.");
			return;
		}
		System.out.println("Decrypted, Verified and Cleaned Document:");
		XmlUtility.writeXML(doc, System.out);
	}
}
