/*
 * @(#) $Id: WSSProcess.java,v 1.1.1.1 2003/10/05 18:39:03 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import com.verisign.xmlsig.Signer;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.VerifyingKeyFactory;
import com.verisign.messaging.WSSecurity;
import com.verisign.messaging.MessageValidity;
import com.verisign.xpath.XPath;
import org.xmltrustcenter.verifier.TrustVerifier;
import org.xmltrustcenter.verifier.X509TrustVerifier;

public class WSSProcess {
	public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.out.println("Usage:: java WSSProcess <inp-file>");
			return;
		}
		String datafile = args[0];

		// Info to get Signing Key.
		String keystore = "my.keystore";
		String storepass = "changeit";
		String kstype = "JCEKS";
		String alias2 = "rsakey";

		System.out.println("Processing SOAP data in file \"" + datafile + "\"");
		System.out.println("Using public key in keystore \"" + keystore + "\" ...");

		// Get the private key and corresponding certificate.
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(kstype);
		ks.load(fis, storepass.toCharArray());
		PrivateKey prvk2 = (PrivateKey)ks.getKey(alias2, storepass.toCharArray());

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);
		TrustVerifier verifier = new X509TrustVerifier(ks);

		WSSecurity wss = new WSSecurity();
		MessageValidity[] resa = wss.verifyAndDecrypt(doc, verifier, null, prvk2, null);

		for (int i = 0; i < resa.length; i++){
			System.out.println("resa[" + i + "].isValid() = " + resa[i].isValid());
			Document doc1 = resa[i].getDocument();
			WSSecurityExtn.removeWSSInfo(doc1);
			XmlUtility.writeXML(doc1, System.out);
		}
	}
}