/*
 * @(#) $Id: EchoClient.java,v 1.1.1.1 2003/10/05 18:39:02 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Service;
import javax.xml.rpc.Call;

import java.util.Vector;
import java.util.HashMap;

public class EchoClient{
    public static void main(String [] args) throws Exception {
		String epAddr = "http://localhost:8080/axis/services/StringEchoPort2";
        String wsdlAddr = epAddr + "?wsdl";
        String nameSpaceUri = "http://www.pankaj-k.net/jsbook/examples/";
        String svcName = "StringEchoService2";
        String portName = "StringEchoPort2";

        java.net.URL wsdlUrl = new java.net.URL(wsdlAddr);
        ServiceFactory svcFactory = ServiceFactory.newInstance();
        QName svcQName = new QName(nameSpaceUri, svcName);
        Service svc = svcFactory.createService(wsdlUrl, svcQName);

		HashMap configProps = new HashMap();
		configProps.put("keyStoreFile", "client.ks");
		configProps.put("trustStoreFile", "client.ts");
		configProps.put("certEntryAlias", "serverkey");

		Class handlerClass = org.jstk.wss4axis.WSSClientHandler.class;
        java.util.List list = svc.getHandlerRegistry().
        		getHandlerChain(new QName(nameSpaceUri, portName));
        list.add(new javax.xml.rpc.handler.HandlerInfo(handlerClass, configProps, null));

        Call call = (Call) svc.createCall();

        call.setTargetEndpointAddress(epAddr);
        call.setOperationName( new QName(nameSpaceUri, "echo") );
        call.setPortTypeName( new QName(nameSpaceUri, portName) );

		Object arg = "Hi, How are you?";
		System.out.println("sending: " + arg );
        String res = (String) call.invoke(new Object[] {arg});
        System.out.println("received: " + res );
    }
}
