/*
 * @(#) $Id: HelloBean.java,v 1.1.1.1 2003/10/05 18:39:01 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package rba;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HelloBean implements SessionBean {

  private SessionContext ctx;
  private int tradeLimit;

  private void log(String s) {
    System.out.println(s);
  }

  public void ejbActivate() {
    log("HelloBean.ejbActivate called");
  }

  public void ejbRemove() {
    log("HelloBean.ejbRemove called");
  }

  public void ejbPassivate() {
    log("HelloBean.ejbPassivate called");
  }

  public void setSessionContext(SessionContext ctx) {
    log("HelloBean.setSessionContext called");
    this.ctx = ctx;

  }

  public void ejbCreate () throws CreateException {
    log("HelloBean.ejbCreate called");
  }

  public String hello(String sub) {
	log("HelloBean.hello(" + sub + ")...");
    log("Prinicpal = " + ctx.getCallerPrincipal());

    return "Hello, " + sub + " !!";
  }
}








