/*
 * @(#) $Id: DefaultBankPersistenceManager.java,v 1.1.1.1 2003/10/05 18:39:19 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.example.bank.server;

import org.jstk.example.bank.*;
import java.util.Iterator;
import java.util.Properties;
import java.io.*;

import java.security.*;

public class DefaultBankPersistenceManager implements BankPersistenceManagerIntf {
	private Bank bank;
	private String filename;
	private boolean noPersistence = false;

	public DefaultBankPersistenceManager(Properties props){
		this.filename = props.getProperty("org.jstk.example.bank.file");
		if (filename == null)
			noPersistence = true;
	}
	public void save(){
		if (noPersistence)
			return;

		ObjectOutputStream oos;
		try {
			oos = new ObjectOutputStream(new FileOutputStream(filename));
			oos.writeObject(bank);
			oos.flush();
			oos.close();
		} catch (IOException ioe){
			System.err.println("writeObject failed: " + ioe);
			noPersistence = true;
		}
	}
	public BankIntf load() throws Exception {
		if (noPersistence){
			bank = new Bank();
		} else {
			ObjectInputStream ois = null;
			bank = null;
			try {
				ois = new ObjectInputStream(new FileInputStream(filename));
				bank = (Bank)ois.readObject();
			} catch (FileNotFoundException fnfe){
				bank = new Bank();
			} catch (IOException ioe){
				System.err.println("Error: reading Bank data from file \"" + filename + "\"");
				System.err.println("Initializing a fresh one.");
				bank = new Bank();
			}
		}

		bank.setPersistenceManager(this);
		Iterator itr = bank._accounts();
		while (itr.hasNext()){
			Account acct = (Account)itr.next();
			acct.setPersistenceManager(this);
		}
		return bank;
	}
}