/*
 * @(#) $Id: BankPermission.java,v 1.1.1.1 2003/10/05 18:39:19 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.example.bank.server;

import java.security.Permission;
import java.util.StringTokenizer;

public class BankPermission extends Permission {
	protected int mask = 0;
	private static int OPEN = 0x01;
	private static int CLOSE = 0x02;
	private static int GET = 0x04;
	private static int LIST = 0x08;

	private String actions = null;

	public BankPermission(String name){
		super(name);
	}

	public BankPermission(String name, String action){
		super(name);
		parse(action);
	}

	private void parse(String action){
		StringTokenizer st = new StringTokenizer(action, ",\t ");
		while (st.hasMoreTokens()){
			String tok = st.nextToken();
			if (tok.equals("open"))
				mask |= OPEN;
			else if (tok.equals("close"))
				mask |= CLOSE;
			else if (tok.equals("get"))
				mask |= GET;
			else if (tok.equals("list"))
				mask |= LIST;
			else
				throw new IllegalArgumentException("Unknown action: " + tok);
		}
	}
    public boolean implies(Permission p) {
		if ((p == null) || (p.getClass() != getClass()))
	    	return false;
		BankPermission that = (BankPermission) p;
		if (getName().equals(that.getName()) || getName().equals("*")){
			if ((mask & that.mask) == that.mask)
				return true;
		}
		return false;
	}

	public boolean equals(Object o){
		if (o == this)
		    return true;

		if ((o == null) || (o.getClass() != getClass()))
		    return false;

		BankPermission that = (BankPermission) o;
		if (getName().equals(that.getName()) && (mask == that.mask))
			return true;
		return false;
	}

    public int hashCode(){
		return (getName().hashCode() ^ mask);
    }

    public String getActions(){
		StringBuffer sb = new StringBuffer();
		if ((mask & OPEN) == OPEN)
			sb.append(" open");
		if ((mask & CLOSE) == CLOSE)
			sb.append(" close");
		if ((mask & GET) == GET)
			sb.append(" get");
		if ((mask & LIST) == LIST)
			sb.append(" list");

		return sb.toString();
	}
}