package server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.AccountIntf;
import javax.security.auth.Subject;
import java.security.PrivilegedExceptionAction;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;

public class RemoteAccountImpl extends UnicastRemoteObject implements common.RemoteAccount {
	private AccountIntf acct = null;
	private Subject sub;

	public RemoteAccountImpl(AccountIntf acct, Subject sub) throws RemoteException {
		this.acct = acct;
		this.sub = sub;
	}
	public RemoteAccountImpl(AccountIntf acct) throws RemoteException {
		this.acct = acct;
		this.sub = null;
	}

	public void deposit(BigDecimal amt) throws Exceptions.AccountClosed, RemoteException {
		final AccountIntf acctf = acct;
		final BigDecimal amtf = amt;
		try {
			Subject.doAs(sub, new PrivilegedExceptionAction() {
				public Object run() throws Exception {
					acctf.deposit(amtf);
					return null;
				}
			});
		} catch (PrivilegedActionException pae){
			if (pae.getException() instanceof Exceptions.AccountClosed)
				throw (Exceptions.AccountClosed)pae.getException();
		}
	}
	public void withdraw(BigDecimal amt) throws Exceptions.AccountClosed,
			Exceptions.InsufficientAmount, RemoteException {
		final AccountIntf acctf = acct;
		final BigDecimal amtf = amt;
		try {
			Subject.doAs(sub, new PrivilegedExceptionAction() {
				public Object run() throws Exception {
					acctf.withdraw(amtf);
					return null;
				}
			});
		} catch (PrivilegedActionException pae){
			if (pae.getException() instanceof Exceptions.AccountClosed)
				throw (Exceptions.AccountClosed)pae.getException();
			else if (pae.getException() instanceof Exceptions.InsufficientAmount)
				throw (Exceptions.InsufficientAmount)pae.getException();
		}
	}
	public void close() throws Exceptions.AccountClosed, RemoteException {
		acct.close();
	}
	public BigDecimal getBalance() throws Exceptions.AccountClosed, RemoteException {
		final AccountIntf acctf = acct;
		BigDecimal balance = null;
		try {
			balance = (BigDecimal)Subject.doAs(sub, new PrivilegedExceptionAction() {
				public Object run() throws Exception {
					return acctf.getBalance();
				}
			});
		} catch (PrivilegedActionException pae){
			if (pae.getException() instanceof Exceptions.AccountClosed)
				throw (Exceptions.AccountClosed)pae.getException();
		}
		return balance;
	}
	public String getAcctNo() throws RemoteException {
		final AccountIntf acctf = acct;
		return (String)Subject.doAs(sub, new PrivilegedAction() {
				public Object run(){
					return acctf.getAcctNo();
				}
			});
	}
	public String getStatement() throws RemoteException {
		return acct.getStatement();
	}
}
