package client;

import java.io.InputStreamReader;
import java.io.BufferedReader;
import common.RemoteBank;
import common.RemoteLoginServer;
import java.rmi.Naming;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jstk.example.bank.client.BankClient;
import javax.security.auth.login.LoginException;

public class RMIBCShell {
    public static void main(String[] args) throws Exception {

		BankClient bc = new BankClient();
		RemoteLoginServer rls = (RemoteLoginServer)Naming.lookup("rmi://" + args[0] + "/" + "MyRemoteLoginServer");

		// Prompt for username and password
		System.out.print("login: ");
		System.out.flush();
		String username = new BufferedReader(new InputStreamReader(System.in)).readLine();
		System.out.print("password: ");
		System.out.flush();
		String password = new BufferedReader(new InputStreamReader(System.in)).readLine();

		RemoteBank rbank = null;
		try {
			rbank = rls.login(username, password);
		} catch (LoginException le){
			System.out.println("Login Failed. " + le.getMessage());
			return;
		}
		bc.init(new BankProxy(rbank));
		while (true){
			System.out.print("rbcsh>");
			System.out.flush();
			String cmdline = new BufferedReader(new InputStreamReader(System.in)).readLine();
			String[] cmdargs = cmdline.split("\\s");

			String result = bc.execCommand(cmdargs);
			System.out.println(result);
		}
	}
}