/*
 * @(#) $Id: Encrypt.java,v 1.1.1.1 2003/10/05 18:39:07 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import javax.crypto.SecretKey;

import com.verisign.xmlenc.Encryptor;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xpath.XPath;

public class Encrypt {
	public static void main(String[] args) throws Exception {
		// Input to signature.
		String datafile = "book.xml";
		String encfile = "enc.xml";
		XPath encloc = new XPath("id('book_info')");
		System.out.println("XML file: " + datafile + ", elem. : bookinfo");

		// Info to get Secret Key.
		String keyfile = "3des.key";


		// Get the secret key from file.
		FileInputStream fis = new FileInputStream(keyfile);
		ObjectInputStream ois = new ObjectInputStream(fis);
		SecretKey key = (SecretKey)ois.readObject();
		System.out.println("Read key from file :" + keyfile);

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);

		Encryptor encryptor = new Encryptor(doc, key, AlgorithmType.TRIPLEDES);

		//encryptor.setContentEncryption(true);
		Document encryptedDoc = encryptor.encrypt(encloc);

		// Write the signed XML file
		XmlUtility.writeXML(encryptedDoc, new FileOutputStream(encfile));

		System.out.println();
		System.out.println("Encryption SUCCESSFUL!!");
		System.out.println("Encrypted doc. written to file: " + encfile);
	}
}