/*
 * @(#) $Id: Decrypt.java,v 1.1.1.1 2003/10/05 18:39:07 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import javax.crypto.SecretKey;

import com.verisign.xmlenc.Decryptor;
import com.verisign.xpath.XPath;

public class Decrypt {
	public static void main(String[] args) throws Exception {
		// Input to signature.
		String encfile = "enc.xml";
		String decfile = "dec.xml";
		System.out.println("Decrypting file: " + encfile);

		// Info to get Secret Key.
		String keyfile = "3des.key";

		// Get the secret key from file.
		FileInputStream fis = new FileInputStream(keyfile);
		ObjectInputStream ois = new ObjectInputStream(fis);
		SecretKey key = (SecretKey)ois.readObject();
		System.out.println("Read key from file :" + keyfile);

		// Read the XML file
		Document doc = XmlUtility.readXML(encfile);

		String[] ns = {"xenc", "http://www.w3.org/2001/04/xmlenc#"};
 		XPath encloc = new XPath("//xenc:EncryptedData", ns);

		Decryptor decryptor = new Decryptor(doc, key, encloc);
		Document decryptedDoc = decryptor.decrypt();

		// Write the signed XML file
		XmlUtility.writeXML(decryptedDoc, new FileOutputStream(decfile));

		System.out.println();
		System.out.println("Decryption SUCCESSFUL!!");
		System.out.println("Decrypted document written to file: " + decfile);
	}
}