@echo off
rem check for env. variable JAVA_HOME

set _JAVA_BIN=%JAVA_HOME%\bin
if "%_JAVA_BIN%" == "\bin" goto jdkNotFound

:start
set _CP=

set SERVER_DN="CN=localhost, OU=X, O=Y, L=Z, S=XY, C=YZ"
set CLIENT_DN="CN=Client, OU=X, O=Y, L=Z, S=XY, C=YZ"
set PROG_DN="CN=Prog, OU=X, O=Y, L=Z, S=XY, C=YZ"
set STOREINFO=-storepass changeit -storetype JCEKS


if "%1" == "" goto printHelp
if "%1" == "one-cert" goto OneCert
if "%1" == "ss-certs" goto SelfSignedCerts
if "%1" == "cs-certs" goto CASignedCerts
goto printHelp

:removeExistingStores
echo.
echo Removing files client.ks, client.ts, server.ks and server.ts ...
echo.
if exist server.ks del server.ks
if exist client.ks del client.ks
if exist server.ts del server.ts
if exist client.ts del client.ts
goto eof1

:OneCert
echo This option creates keystore and truststore files with a single cert.
call :removeExistingStores

%JAVA_HOME%\bin\keytool -genkey -dname %PROG_DN% %STOREINFO% -keystore server.ks %KEYINFO%
copy server.ks client.ks
copy server.ks server.ts
copy server.ks client.ts

goto eof

:SelfSignedCerts
echo This option creates keystore and truststore files using self-signed certs.
call :removeExistingStores


set KEYINFO=-keyalg RSA

echo Creating a server certificate in keystore server.ks, exporting it
echo to a temporary file, and then importing it to client truststore client.ts
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %SERVER_DN% %STOREINFO% -keystore server.ks %KEYINFO% -keypass changeit
%java_home%\bin\keytool -export -file temp$.cer %STOREINFO% -keystore server.ks
%java_home%\bin\keytool -import -file temp$.cer %STOREINFO% -keystore client.ts -alias serverkey -noprompt

echo Creating a client certificate in keystore client.ks, exporting it
echo to a temporary file, and then importing it to server truststore server.ts
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %CLIENT_DN% %STOREINFO% -keystore client.ks %KEYINFO% -keypass changeit
%java_home%\bin\keytool -export -file temp$.cer %STOREINFO% -keystore client.ks
%java_home%\bin\keytool -import -file temp$.cer %STOREINFO% -keystore server.ts -alias clientkey -noprompt

del temp$.cer
echo.
echo setup done for using self-signed certificates.


goto eof

:CASignedCerts

set _JSTK_HOME=%JSTK_HOME%
if "%_JSTK_HOME%" == "" goto jstkHomeNotSet

echo This option creates keystore and truststore files using CA signed certs.
call :removeExistingStores

echo Creating a self-signed server certificate in keystore server.ks, generating 
echo a CSR, issuing a CA-signed certificate and importing this certificate to
echo server.ks.
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %SERVER_DN% %STOREINFO% -keystore server.ks
%java_home%\bin\keytool -certreq -file temp$.csr %STOREINFO% -keystore server.ks
call %JSTK_HOME%\bin\certtool issue -csrfile temp$.csr -cerfile server.cer -password changeit
echo on
%java_home%\bin\keytool -import -file server.cer %STOREINFO% -keystore server.ks -noprompt

echo Creating a self-signed server certificate in keystore client.ks, generating 
echo a CSR, issuing a CA-signed certificate and importing this certificate to
echo client.ks.
echo.
%JAVA_HOME%\bin\keytool -genkey -dname %CLIENT_DN% %STOREINFO% -keystore client.ks
%java_home%\bin\keytool -certreq -file temp$.csr %STOREINFO% -keystore client.ks
call %JSTK_HOME%\bin\certtool issue -csrfile temp$.csr -cerfile client.cer -password changeit
echo on
%java_home%\bin\keytool -import -file client.cer %STOREINFO% -keystore client.ks -noprompt

del temp$.csr

echo Exporting the CA certificate and importing it in server and client trusstore
%java_home%\bin\keytool -export -file temp$.cer %STOREINFO% -keystore cadir\ca.ks -alias cakey
%java_home%\bin\keytool -import -file temp$.cer %STOREINFO% -keystore client.ts -noprompt
%java_home%\bin\keytool -import -file temp$.cer %STOREINFO% -keystore server.ts -noprompt

del temp$.cer
echo.
echo setup done for using CA-signed certificates.
goto eof

:printHelp
echo Usage :: sslsetup ^<arg1^>
echo.
echo Where ^<arg1^> is one of:
echo     one-cert : client and server keystore and truststore with same self signed cert.
echo     ss-certs : keystore and truststore with self signed certs.
echo     cs-certs : keystore with CA signed certs and truststore with CA cert.
echo.
echo.
echo This program removes existing files client.ks, client.ts, server.ks 
echo and server.ts from the current diretory and creates new ones for
echo ss-certs and cs-certs options.
echo.
goto eof

:jstkHomeNotSet
echo.
echo Environment variable JSTK_HOME is not set.
echo.
goto eof

:jdkNotFound
echo You must have JAVA_HOME set to your JDK Installation directory.

:eof
set _JSTK_HOME=
set _JAVA_BIN=
set _CP=
:eof1
