/*
 * @(#) $Id: EchoGWBean.java,v 1.1.1.1 2003/10/05 18:39:00 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package gw;

import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import echo.EchoHome;
import echo.Echo;

public class EchoGWBean implements SessionBean {
	private SessionContext ctx;
	private String targetUrl;
	private String targetJNDIName;

	public void ejbActivate() {
		System.out.println("EchoGWBean.ejbActivate called");
	}

	public void ejbRemove() {
		System.out.println("EchoGWBean.ejbRemove called");
	}

	public void ejbPassivate() {
		System.out.println("EchoGWBean.ejbPassivate called");
	}

	public void setSessionContext(SessionContext ctx) {
		System.out.println("EchoGWBean.setSessionContext called");
		this.ctx = ctx;
	}

	public void ejbCreate () throws CreateException {
		System.out.println("EchoGWBean.ejbCreate called");
	}

	public String gwEcho(String arg) {
		System.out.println("----- BEGIN EchoGWBean.gwEcho(\"" + arg + "\") -----");
		printCallerInfo();

		String retval = "Cannot Forward";

		try {
			getEnvEntries();
			Properties h = new Properties();
			h.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");
			h.put(Context.PROVIDER_URL, targetUrl);
			InitialContext ic = new InitialContext(h);
			Object home = ic.lookup(targetJNDIName);
			EchoHome echoHome = (EchoHome)PortableRemoteObject.narrow(home, EchoHome.class);
			Echo echo = (Echo) PortableRemoteObject.narrow(echoHome.create(), Echo.class);
			System.out.println("----- END EchoGWBean.gwEcho() -----");
			retval = echo.echo("gwEcho:: " + arg);
		} catch (Exception e){
			System.err.println("gwEcho:: Exception -- " + e);
		}
		return retval;
	}

	private void printCallerInfo(){
		java.security.Principal caller = ctx.getCallerPrincipal();
		boolean inRole = ctx.isCallerInRole("echomanager");
		System.out.println("Caller Name: " + caller.getName());
		System.out.println("Caller in role \"echomanager\"? " + inRole);
	}

	public void getEnvEntries() throws javax.naming.NamingException {
		InitialContext ic = new InitialContext();
		targetUrl = (String)ic.lookup("java:comp/env/target_url");
		targetJNDIName = (String)ic.lookup("java:comp/env/target_jndi_name");
	}
}








