/*
 * @(#) $Id: Client.java,v 1.1.1.1 2003/10/05 18:38:59 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.rmi.RemoteException;
import java.util.Properties;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import echo.*;

public class Client {
	public static void main(String[] args) throws Exception {
		String url = null;
		String uname = null;
		String passwd = null;
		if (args.length > 2){
			url = args[0];
			uname = args[1];
			passwd = args[2];
		} else {
			System.out.println("Usage:: java client.Client <url> <uname> <passwd>");
			System.exit(0);
		}

		Properties h = new Properties();

		//h.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.cosnaming.CNCtxFactory");
		h.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");

		h.put(Context.PROVIDER_URL, url);
		h.put(Context.SECURITY_PRINCIPAL, uname);
		h.put(Context.SECURITY_CREDENTIALS, passwd);
		Context ctx = new InitialContext(h);

		Object home = ctx.lookup("ex2-echo-EchoHome");
		EchoHome ehome = (EchoHome)narrow(home, EchoHome.class);
		Echo estub = (Echo)narrow(ehome.create(), Echo.class);

		String msg = "Hello, World!!";
		System.out.println("Calling Echo.echo(\"" + msg + "\") ...");
		String resp = estub.echo(msg);
		System.out.println("... Echo.echo(\"" + msg + "\") = " + resp);

		System.out.println("... Echo Client Executed successfully.");
	}
	private static Object narrow(Object o, Class c){
		return javax.rmi.PortableRemoteObject.narrow(o, c);
	}
}
