package isrp.hibernate.model.util.email;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import isrp.hibernate.model.businessobject.Paper;
import isrp.hibernate.model.businessobject.User;

/**
 * Klasa odpowiedzialna za generowanie tresci emaili (lokalizowane zasoby pobierane sa z pliku Messages.properties).
 * acuchy sa sparametryzowane.
 */
public class EmailMessagesUtil {

	private static ResourceBundle resource= ResourceBundle.getBundle("isrp.messages.Messages");
	
	public static String getString(String key, Object... params  ) {
        try {
            return MessageFormat.format(resource.getString(key), params);
        } catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }
	public static EmailContent newPaperVersionMessage(User author, Paper paper,
			String toAddress, String toName) {
		String title = resource.getString("new.version");
		String message = getString("new.version.msg",author.getFirstName(), author.getLastName(),paper.getTitle(), paper.getAuthors(), paper.getAbstract_());
		return new EmailContent(toAddress, toName, title, message);
	}

	public static EmailContent newPaperMessageToAuthor(User author, Paper paper) {
		String title = resource.getString("new.paperadded");
		String message = getString("new.paper.msg.toAuthor",paper.getTitle(), paper.getAuthors(), paper.getAbstract_());
		return new EmailContent(author.getEmail(), author.getFirstName() + " "
				+ author.getLastName(), title, message);
	}

	public static EmailContent newPaperMessageToAdministrator(User author,
			Paper paper, String adminEmail) {
		String title = resource.getString("new.paper");
		String message = getString("new.paper.msg",author.getFirstName(), author.getLastName(),paper.getTitle(), paper.getAuthors(), paper.getAbstract_());
		return new EmailContent(adminEmail, "Administrator", title, message);
	}

	public static EmailContent newAuthorRegistrationMessage(User author) {
		String title = resource.getString("new.author");
		String message = getString("new.author.msg",author.getFirstName());
		return new EmailContent(author.getEmail(), author.getFirstName() + " "
				+ author.getLastName(), title, message);
	}

	public static EmailContent newReviewerRegistrationMessage(User reviewer,
			String passwordCopy) {
		String title = resource.getString("reviewer.registration");
		String message = getString("reviewer.registration.msg",reviewer.getFirstName(),reviewer.getEmail(),passwordCopy);
				
		return new EmailContent(reviewer.getEmail(), reviewer.getFirstName()
				+ " " + reviewer.getLastName(), title, message);
	}

	public static EmailContent newReviewMessage(User reviewer, Paper paper,
			String toAddress, String toName) {
		String title = resource.getString("new.review");
		String message = getString("new.review.msg", reviewer.getFirstName(),reviewer.getLastName(),paper.getTitle());
		return new EmailContent(toAddress, toName, title, message);
	}

	public static EmailContent assignReviewerMessageToReviewer(User reviewer,
			Paper paper) {
		String title = resource.getString("reviewer.assignment");
		String message = getString("reviewer.assignment.msg",reviewer.getFirstName(),reviewer.getLastName(),paper.getTitle());
		return new EmailContent(reviewer.getEmail(), reviewer.getFirstName()
				+ " " + reviewer.getLastName(), title, message);
	}

	public static EmailContent assignReviewerMessageToAuthor(User author) {
		String title = resource.getString("reviewer.assigned");
		String message = getString("reviewer.assigned.msg",author.getFirstName(),author.getLastName());
		return new EmailContent(author.getEmail(), author.getFirstName() + " "
				+ author.getLastName(), title, message);
	}

	public static EmailContent sendNewPasswordToUser(User user, String password) {
		String title = resource.getString("new.password");
		String message = getString("new.password.msg", user.getFirstName(),user.getLastName(), password);
		return new EmailContent(user.getEmail(), user.getFirstName() + " "
				+ user.getLastName(), title, message);
	}

	public static EmailContent paperApprovedMessage(User author) {
		String title = resource.getString("acceptance.info");
		String message = getString("acceptance.info.msg", author.getFirstName(),author.getLastName()); 
		
		return new EmailContent(author.getEmail(), author.getFirstName() + " "
				+ author.getLastName(), title, message);
	}

	public static EmailContent paperRejectedMessage(User author) {
		String title = resource.getString("acceptance.rejection.info");
		String message = getString("acceptance.rejection.msg",author.getFirstName(), author.getLastName());
				
		return new EmailContent(author.getEmail(), author.getFirstName() + " "
				+ author.getLastName(), title, message);
	}
}
