package isrp.viewbeans;

import isrp.hibernate.model.businessobject.Paper;
import isrp.model.service.PaperService;
import isrp.utils.IsrpUtils;
import isrp.utils.MessageUtil;

import java.io.Serializable;

import javax.faces.context.FacesContext;

import org.apache.myfaces.custom.fileupload.UploadedFile;

/**Komponent wsparcia dla dodawania i edytowania prac oraz dodawania drugiej wersji pracy.
 */
public class AddEditPaperBean implements Serializable {
	
	private static final long serialVersionUID = 1L;
	private VisitBean visitBean;
	private UploadedFile uploadedFile;
	private String fileName;
	private UtilBean utilBean;

	public String addNewVersion() {
		FacesContext ctx = FacesContext.getCurrentInstance();
		Paper paper = visitBean.getCurrentPaper();
		paper.setLastUpdate(IsrpUtils.getCurrentDate());
		
	
		if (utilBean == null) utilBean=(UtilBean)ctx.getApplication().evaluateExpressionGet(ctx, "#{utilBean}", UtilBean.class);
		
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();		
		if (paperSer.addPaperNewVersion(paper, visitBean.getUser(),
				uploadedFile, utilBean.getUploadPath(),utilBean.getEmailConfiguration())) {
			// musimy wymusi odwieenie papersListBean
			PapersListBean pBean = (PapersListBean) IsrpUtils.getBean(
					FacesContext.getCurrentInstance(), "sessionScope",
					"papersListBean");
			pBean.setPapersList(null);
		} else {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),
					"papers.addNewVersionFaild");
		}
		return "author_papers_list";
	}

	public String editPaper() {
		// visitBean.getCurrentPaper().setLastUpdate(IsrpUtils.getCurrentDate());
		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		visitBean.getCurrentPaper().setLastUpdate(IsrpUtils.getCurrentDate());
		paperSer.update(visitBean.getCurrentPaper());
		// musimy wymusi odwieenie papersListBean
		PapersListBean pBean = (PapersListBean) IsrpUtils.getBean(FacesContext
				.getCurrentInstance(), "sessionScope", "papersListBean");
		pBean.setPapersList(null);
		return "author_papers_list";
	}

	public String toAddPaperPage() {
		visitBean.setCurrentPaper(new Paper());
		return "add_paper";
	}

	public String addPaper() {

		Paper paper = new Paper();
		paper.setAbstract_(visitBean.getCurrentPaper().getAbstract_());
		paper.setAcronym(visitBean.getCurrentPaper().getAcronym());
		paper.setAuthors(visitBean.getCurrentPaper().getAuthors());
		paper.setTitle(visitBean.getCurrentPaper().getTitle());
		paper.setAuthorId(visitBean.getUser().getId());
		paper.setLastUpdate(IsrpUtils.getCurrentDate());
		paper.setPath("");
		paper.setSubmissionTime(IsrpUtils.getCurrentDate());
		paper.setVersion(new Byte("1"));
		paper.setStatus(new Byte("0"));

		PaperService paperSer = utilBean.getServiceLocator().getPaperService();
		if (paperSer.addPaper(paper, visitBean.getUser(), uploadedFile,
				utilBean.getUploadPath(),utilBean.getEmailConfiguration())) {

			// musimy wymusi odwieenie papersListBean
			PapersListBean pBean = (PapersListBean) IsrpUtils.getBean(
					FacesContext.getCurrentInstance(), "sessionScope",
					"papersListBean");
			if (pBean != null) {
				pBean.setPapersList(null);
			}
		} else {
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),"papers.addNPaperFaild");
		}
		return "author_papers_list";
	}

	public VisitBean getVisitBean() {
		return visitBean;
	}

	public void setVisitBean(VisitBean visitBean) {
		this.visitBean = visitBean;
	}

	public UploadedFile getUploadedFile() {
		return uploadedFile;
	}

	public void setUploadedFile(UploadedFile uploadedFile) {
		this.uploadedFile = uploadedFile;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public void setUtilBean(UtilBean utilBean) {
		this.utilBean = utilBean;
	}

	public UtilBean getUtilBean() {
		return utilBean;
	}

}
