package isrp.hibernate.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.SessionFactory;

public class HibernateUtil {
	private static final SessionFactory sessionFactory;
	private static final Log log = LogFactory.getLog(HibernateUtil.class);

    static {
        try {
            // Create the SessionFactory from standard (hibernate.cfg.xml) 
            // config file.
            sessionFactory = new AnnotationConfiguration().configure().buildSessionFactory();
        } catch (Throwable ex) {
            // Log the exception. 
        	log.error("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);            
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }
}
