package various;

import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseId;

/**Klasa obiektu nasuchujcego zdarzenia akcji. 
 * W przykadzie obiekt nasuchujcy realizuje operacj 
 * zapisywania do dziennika informacji o obsugiwanych 
 * zdarzeniach i moe by przypisywany do obsugi dowolnych 
 * komponentw UI generujcych akcje (patrz rozdzial 3.2). 
 */
public class ActionEventLogger implements ActionListener {

	@Override
	public void processAction(ActionEvent event) throws AbortProcessingException {
		FacesContext.getCurrentInstance().getExternalContext().log(event.getComponent() + "has generated" + event.toString());
	}
	public PhaseId getPhaseId() {
		return PhaseId.PROCESS_VALIDATIONS;
		}

}
