package isrp.hibernate.model.util.email;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *Klasa odpowiedzialna za generowanie wiadomosci e-mail.
 *Uwaga W przypadku wystpienia bedw podczas wysylania maili, transakcje w bazie danych nie s wycofywane!
 *
 */
public class EmailSender {
	private EmailConfiguration emailConfiguration;
	private Log logger = LogFactory.getLog(this.getClass());

	public EmailSender(EmailConfiguration emailConfiguration) {
		this.emailConfiguration = emailConfiguration;
	}

	public boolean sendEMail(EmailContent emailContent) {
		try {
			String copyAddress = emailConfiguration.getEmailAddressForTesting();
			Properties props = new Properties();
			props.put("mail.smtps.auth", "true");
			Session session = Session.getDefaultInstance(props);
			MimeMessage msg = new MimeMessage(session);
			msg.setFrom(new InternetAddress(emailConfiguration
					.getEmailUsername()+'@'+emailConfiguration.getEmailHost(),
					"Internetowy system recenzowania publikacji"));
			msg.addRecipient(Message.RecipientType.BCC, new InternetAddress(
					copyAddress));
			msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
					emailContent.getToAddress(), emailContent.getToName()));
			msg.setSubject(emailContent.getTitle());
			msg.setText(emailContent.getMessage());
			Transport t = session.getTransport("smtps");
			t.connect(emailConfiguration.getEmailHost(), emailConfiguration
					.getEmailUsername(), emailConfiguration.getEmailPassword());
			t.sendMessage(msg, msg.getAllRecipients());
			t.close();
		} catch (MessagingException ex) {
			logger.error(ex.getMessage());
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return true;
	}

}
