package various.uicomponents;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

/**
 * Kod klasy renderera ktry renderuje komponent ComboFieldset w taki sposb,
 * aby pniej na stronie wynikowej mona byo go zwija
 * i rozwija przy uyciu skryptw JS.
 *
 */
public class ComboFieldsetJSRenderer extends Renderer {

	
	public void encodeBegin(FacesContext context, UIComponent _component)
			throws IOException {
		ComboFieldset component = (ComboFieldset) _component;
		if (!component.isRendered()) {
			return;
		}
		String clientId = component.getClientId(context);
		ResponseWriter writer = context.getResponseWriter();
		writer.startElement("fieldset", component);
		// poniej kod odpowiedzialny za komunikacj ze skryptem JS
		if (component.isRolled())
			writer.writeAttribute("class", "collapsible", null);
		// rozwinity
		else
			writer.writeAttribute("class", "startClosed", null);
		// zwinity
		writer.writeAttribute("id", clientId, null);
		writer.startElement("legend", component);
		if (component.getLegend() != null)
			writer.write(component.getLegend());
		writer.endElement("legend");
	}

	
	
	
	@Override
	public void decode(FacesContext context, UIComponent component) {
		super.decode(context, component);
	}




	@Override
	public void encodeChildren(FacesContext arg0, UIComponent arg1)
			throws IOException {
		super.encodeChildren(arg0, arg1);
	}

	@Override
	public void encodeEnd(FacesContext context, UIComponent component)
			throws IOException {
		ResponseWriter writer = context.getResponseWriter();
		writer.endElement("fieldset");
	}

	@Override
	public boolean getRendersChildren() {
		return super.getRendersChildren();
	}

}
