<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:f="http://java.sun.com/jsf/core"
	xmlns:h="http://java.sun.com/jsf/html" version="2.0">
	<jsp:directive.page language="java"
		contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" />
	<jsp:text>
		<![CDATA[ <?xml version="1.0" encoding="UTF-8" ?> ]]>
	</jsp:text>
	<jsp:text>
		<![CDATA[ <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> ]]>
	</jsp:text>
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<jsp:include page='../includes/header.jsp'>
		<jsp:param name="title" value="all paper list" />
	</jsp:include>
	</head>
	<body>
	<f:view>
		<div id="PAGE" class = "site">
<div><div class="header"></div></div>
<div class="center_s">	
		<jsp:include page='../includes/topMenu.jsp' /> <jsp:include
			page='../includes/leftMenu.jsp' />
			
		<div id="CONTENT" class="content">
			<h:messages globalOnly="true"></h:messages>
			<h:form rendered="#{! empty papersListBean.papersList}">
			<h:panelGrid>
				<f:facet name="header">
					<h:outputText value="#{resources['papersList.form.label']}" />
				</f:facet>
				<h:dataTable styleClass="tabela"  border="1" value="#{papersListBean.papersList}" var="paper">
					<h:column>
						<f:facet name="header">
							<h:commandLink id="title" actionListener="#{papersListBean.sort}">
								<h:outputText value="#{resources['addEditUser.field.label.title']}"></h:outputText>
							</h:commandLink>
						</f:facet>
						<h:outputText value="#{paper.title}"></h:outputText>
					</h:column>
					<h:column>
						<f:facet name="header">
							<h:commandLink id="authors" actionListener="#{papersListBean.sort}">
								<h:outputText value="#{resources['addEditPaper.field.label.authors']}"></h:outputText>
							</h:commandLink>
						</f:facet>
						<h:outputText value="#{paper.authors}"></h:outputText>
					</h:column>	
					<h:column>
						<f:facet name="header">
							<h:commandLink id="reviewer" actionListener="#{papersListBean.sort}">
								<h:outputText value="#{resources['papersList.column.label.reviewer']}"></h:outputText>
							</h:commandLink>
						</f:facet>
						<h:outputText value="#{paper.reviewer.firstName} #{paper.reviewer.lastName}" rendered="#{!empty paper.reviewer}"></h:outputText>
						<h:outputText value="-" rendered="#{empty paper.reviewer}"></h:outputText>
					</h:column>		
					<h:column>
						<f:facet name="header">
							<h:commandLink id="status" actionListener="#{papersListBean.sort}">
								<h:outputText value="Status"></h:outputText>
							</h:commandLink>
						</f:facet>
						<h:outputText value="#{resources['authorPapersList.row.label.new']}" rendered="#{paper.status == 0}"></h:outputText>
						<h:outputText value="#{resources['authorPapersList.row.label.assignedReviewer']}" rendered="#{paper.status == 1}"></h:outputText>
						<h:outputText value="#{resources['authorPapersList.row.label.reviewComplete']}" rendered="#{paper.status == 2}"></h:outputText>
						<h:outputText value="#{resources['authorPapersList.row.label.approved']}" rendered="#{paper.status == 3}"></h:outputText>
						<h:outputText value="#{resources['authorPapersList.row.label.rejected']}" rendered="#{paper.status == 4}"></h:outputText>
					</h:column>
					<h:column>
						<f:facet name="header">							
							<h:outputText value="#{resources['authorPapersList.row.label.wersion']}"></h:outputText>
						</f:facet>
						<h:outputText value="#{paper.version}"></h:outputText>															
					</h:column>
					<h:column>
						<f:facet name="header">							
							<h:outputText value="#{resources['authorPapersList.column.label.review']}"></h:outputText>
						</f:facet>
						<h:outputText value="#{resources['authorPapersList.row.label.noReview']}" rendered="#{(paper.status == 0) || (paper.status == 1) }" ></h:outputText>
						<h:commandLink id="review" action="#{papersListBean.toReviewDetailsPage}" rendered="#{paper.status >= 2}">
								<h:outputText value="#{resources['authorPapersList.row.label.showReview']}"></h:outputText>
						</h:commandLink>															
					</h:column>			
					<h:column>
						<f:facet name="header">
							<h:outputText value="#{resources['authorPapersList.column.label.paper']}"></h:outputText>
						</f:facet>		
						<h:commandLink action="#{papersListBean.toPaperDetailsPage}">
							<h:outputText value="#{resources['authorPapersList.row.label.details']}"></h:outputText>
						</h:commandLink>						
					</h:column>
					<h:column>
						<h:commandLink action="#{papersListBean.deletePaper}">
							<h:outputText value="#{resources['papersList.row.label.delete']}"></h:outputText>
						</h:commandLink>
					</h:column>		
					<h:column >
						<h:commandLink action="#{papersListBean.toAssignReviewerPage}" rendered="#{empty paper.reviewerId}">
							<h:outputText value="#{resources['papersList.row.label.addReviewer']}"></h:outputText>
						</h:commandLink>
					</h:column>
					<h:column >
						<h:panelGroup rendered="#{paper.status == 2}">
						<h:commandLink action="#{papersListBean.approvePaper}" >
							<h:outputText value="#{resources['papersList.row.label.approve']}"></h:outputText>
						</h:commandLink>
						<h:outputText value=" / "></h:outputText>
						<h:commandLink action="#{papersListBean.rejectPaper}" >
							<h:outputText value="#{resources['papersList.row.label.reject']}"></h:outputText>
						</h:commandLink>
						</h:panelGroup>
					</h:column>				
				</h:dataTable>
			</h:panelGrid>
		</h:form>
		<h:outputText value="#{resources['admin.no.papers']}" rendered="#{empty papersListBean.papersList}"></h:outputText>
		</div>
		</div>
		</div>
		<div class="footer"></div>
	</f:view>
	</body>
	</html>
</jsp:root>