package isrp.model.service.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import isrp.model.service.CountryService;
import isrp.model.service.PaperService;
import isrp.model.service.QuestionService;
import isrp.model.service.ReviewService;
import isrp.model.service.UserService;
import isrp.model.service.impl.CountryServiceImpl;
import isrp.model.service.impl.PaperServiceImpl;
import isrp.model.service.impl.QuestionServiceImpl;
import isrp.model.service.impl.ReviewServiceImpl;
import isrp.model.service.impl.UserServiceImpl;

/**
 * Implementacja interfejsu lokalizatora uslug (patrz rozdzial 2)
 * 
 */
public class ServiceLocatorImpl implements ServiceLocator {

	private PaperService paperService;
	private UserService userService;
	private ReviewService reviewService;
	private CountryService countryService;
	private QuestionService questionService;

	private Log logger = LogFactory.getLog(this.getClass());

	public ServiceLocatorImpl() {
		this.paperService = new PaperServiceImpl();
		this.userService = new UserServiceImpl();
		this.reviewService = new ReviewServiceImpl();
		this.countryService = new CountryServiceImpl();
		this.questionService = new QuestionServiceImpl();
		this.logger.info("Service locator bean is initialized");
	}

	@Override
	public PaperService getPaperService() {
		return paperService;
	}

	@Override
	public UserService getUserService() {
		return userService;
	}

	@Override
	public ReviewService getReviewService() {
		return reviewService;
	}

	@Override
	public CountryService getCountryService() {
		return countryService;
	}

	@Override
	public QuestionService getQuestionService() {
		return questionService;
	}

}
