package isrp.viewbeans;

import isrp.hibernate.model.businessobject.Answer;
import isrp.hibernate.model.businessobject.Paper;
import isrp.hibernate.model.businessobject.Question;
import isrp.hibernate.model.businessobject.Review;
import isrp.model.service.QuestionService;
import isrp.model.service.ReviewService;
import isrp.utils.IsrpUtils;
import isrp.utils.MessageUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

/**
 * Komponent wsparcia dla dodawania recenzji.
 *
 */
public class AddReviewBean implements Serializable {

	private static final long serialVersionUID = 1L;
	private javax.faces.component.UIData questionsTable;
	private VisitBean visitBean;
	private List<Question> questions;
	private List<SelectItem> answersArray[];
	@SuppressWarnings("unchecked")
	private List selectedAnswersArray[];
	private List<SelectItem> grades;
	private UtilBean utilBean;
	
	@SuppressWarnings("unchecked")
	public AddReviewBean() {
		FacesContext ctx = FacesContext.getCurrentInstance();
		if (utilBean == null) utilBean=(UtilBean)ctx.getApplication().evaluateExpressionGet(ctx, "#{utilBean}", UtilBean.class);
		QuestionService qSer = utilBean.getServiceLocator().getQuestionService();
		questions = qSer.findAll();			
		
		answersArray = new List[questions.size()];
		selectedAnswersArray = new List[questions.size()];
		for (int i = 0; i < questions.size(); i++) {
			answersArray[i] = new ArrayList<SelectItem>();
			selectedAnswersArray[i] = new ArrayList();
			Question q = questions.get(i);
			Iterator it = q.getAnswers().iterator();
			while (it.hasNext()) {
				Answer ans = (Answer) it.next();
				answersArray[i].add(new SelectItem(new Integer(ans.getId()),
						ans.getAnswer()));				
			}
		}
		
		grades = new ArrayList<SelectItem>(); 		
		grades.add(new SelectItem(1,"1"));
		grades.add(new SelectItem(2,"2"));
		grades.add(new SelectItem(3,"3"));
		grades.add(new SelectItem(4,"4"));
		grades.add(new SelectItem(5,"5"));
		grades.add(new SelectItem(6,"6"));
	}

	public String addReview(){		
		boolean noAnswer=false;
		for (int i = 0; i < questions.size(); i++) {
			if (selectedAnswersArray[i].size()==0){				
				MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(),"review.message.noCheckbox",questions.get(i).getQuestion());
				noAnswer=true;
			}
		}
		if(noAnswer){
			return null;
		}
		Review review = visitBean.getCurrentReview();
		Paper paper = visitBean.getCurrentPaper();
						
		review.setPaperId(paper.getId());
		review.setReviewerId(visitBean.getUser().getId());
		//zrecenzowany status
		paper.setStatus(new Byte("2"));
		
		ReviewService reviewSer = utilBean.getServiceLocator().getReviewService();				
		reviewSer.addNewReview(review,paper,selectedAnswersArray,questions,visitBean.getUser(),utilBean.getEmailConfiguration());
				
		//sending email
		
		//musimy wymusi odwieenie papersListBean
		PapersListBean pBean = (PapersListBean) IsrpUtils.getBean(FacesContext.getCurrentInstance(), "sessionScope","papersListBean");
		pBean.setPapersList(null);
		return "reviewer_papers_list";
	}

	public UtilBean getUtilBean() {
		return utilBean;
	}

	public void setUtilBean(UtilBean utilBean) {
		this.utilBean = utilBean;
	}
	
	
	public List<SelectItem> getGrades() {
		return grades;
	}


	public void setGrades(List<SelectItem> grades) {
		this.grades = grades;
	}

	public List<SelectItem>[] getAnswersArray() {
		return answersArray;
	}



	public void setAnswersArray(List<SelectItem>[] answersArray) {
		this.answersArray = answersArray;
	}



	@SuppressWarnings("unchecked")
	public List<SelectItem>[] getSelectedAnswersArray() {
		return selectedAnswersArray;
	}



	public void setSelectedAnswersArray(List<SelectItem>[] selectedAnswersArray) {
		this.selectedAnswersArray = selectedAnswersArray;
	}


	public VisitBean getVisitBean() {
		return visitBean;
	}

	public void setVisitBean(VisitBean visitBean) {
		this.visitBean = visitBean;
	}

	public List<Question> getQuestions() {
		return questions;
	}

	public void setQuestions(List<Question> questions) {
		this.questions = questions;
	}

	public javax.faces.component.UIData getQuestionsTable() {
		return questionsTable;
	}

	public void setQuestionsTable(javax.faces.component.UIData questionsTable) {
		this.questionsTable = questionsTable;
	}


}
