package isrp.viewbeans;

import isrp.hibernate.model.util.email.EmailConfiguration;
import isrp.model.service.factory.ServiceLocator;

import java.io.Serializable;

import javax.faces.context.FacesContext;

/**
 * Komponent wsparcia suacy do przechowywania ustawie aplikacji.
 *
 */
public class UtilBean implements Serializable {

	private static final String MANAGED_BEAN_NAME = "utilBean";

	private static final long serialVersionUID = 1L;

	public static UtilBean getCurrentInstance() {
		FacesContext ctx = FacesContext.getCurrentInstance();
		return (UtilBean) ctx.getApplication().evaluateExpressionGet(ctx,
				"#{" + MANAGED_BEAN_NAME + "}", UtilBean.class);
	}
	private EmailConfiguration emailConfiguration;
	private ServiceLocator serviceLocator;

	private String uploadPath;

	public UtilBean() {
	}

	public EmailConfiguration getEmailConfiguration() {
		return emailConfiguration;
	}

	public ServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public String getUploadPath() {
		return uploadPath;
	}

	public void setEmailConfiguration(EmailConfiguration emailConfiguration) {
		this.emailConfiguration = emailConfiguration;
	}

	public void setServiceLocator(ServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public void setUploadPath(String uploadPath) {
		this.uploadPath = uploadPath;
	}

}
