<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:f="http://java.sun.com/jsf/core"
	xmlns:h="http://java.sun.com/jsf/html" version="2.0">
	<jsp:directive.page language="java"
		contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" />
	<jsp:text>
		<![CDATA[ <?xml version="1.0" encoding="UTF-8" ?> ]]>
	</jsp:text>
	<jsp:text>
		<![CDATA[ <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> ]]>
	</jsp:text>
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<jsp:include page='../includes/header.jsp'>
		<jsp:param name="title" value="user list page" />
	</jsp:include>
	</head>
	<body>
	<f:view>
		<jsp:include page='../includes/header_body.jsp' />
		<jsp:include page='../includes/topMenu.jsp' /> 
		<jsp:include page='../includes/leftMenu.jsp' />
		<div id="CONTENT" class="content"><div class="text">
			<h:messages globalOnly="true"></h:messages>
			<h:form>
			<h:panelGrid>
				<f:facet name="header">
					<h:outputText value="#{resources['usersList.form.label']}" />
				</f:facet>
				<h:dataTable styleClass="tabela" border="1" value="#{usersListBean.usersList}"
					 var="user">
					<h:column>
						<f:facet name="header">
							<h:commandLink id="firstName" actionListener="#{usersListBean.sort}">
								<h:outputText value="#{resources['addEditUser.field.label.firstName']}"></h:outputText>
							</h:commandLink>
						</f:facet>
						<h:outputText value="#{user.firstName}"></h:outputText>
					</h:column>
					<h:column>
						<f:facet name="header">
							<h:commandLink id="lastName" actionListener="#{usersListBean.sort}">
								<h:outputText value="#{resources['addEditUser.field.label.lastName']}"></h:outputText>
							</h:commandLink>
						</f:facet>
						<h:outputText value="#{user.lastName}"></h:outputText>
					</h:column>
					<h:column>
						<f:facet name="header">
							<h:commandLink id="role" actionListener="#{usersListBean.sort}">
								<h:outputText value="#{resources['addEditUser.field.label.role']}"></h:outputText>
							</h:commandLink>
						</f:facet>
						<h:outputText value="#{resources['user.role.admin']}" rendered="#{user.role == 1}"></h:outputText>
						<h:outputText value="#{resources['user.role.author']}" rendered="#{user.role == 2}"></h:outputText>
						<h:outputText value="#{resources['user.role.reviewer']}" rendered="#{user.role == 3}"></h:outputText>
					</h:column>						
					<h:column>
						<h:commandLink action="#{usersListBean.toEditUserPage}">
							<h:outputText value="#{resources['usersList.row.label.edit']}"></h:outputText>
						</h:commandLink>
					</h:column>
					<h:column>
						<h:commandLink action="#{usersListBean.deleteUser}">
							<h:outputText value="#{resources['usersList.row.label.delete']}"></h:outputText>
						</h:commandLink>
					</h:column>
				</h:dataTable>
			</h:panelGrid>
		</h:form></div>
		</div>
		<jsp:include page='../includes/footer2.jsp' />
	</f:view>
	</body>
	</html>
</jsp:root>