package various;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlForm;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.validator.DoubleRangeValidator;

/**
 * Obiekt Backing Bean wykorzystywany do testowania widokw JSF. 
 *
 */
public class BB {
	private String email = "a.m@helion.pl";
	private Date date = new Date();
	private Double total;// =new Double(234.45);
	private ZipCode zipCode;
	private HtmlInputText price;
	private String opcje = null;
	private int number = 2;
	private boolean gender;
	private int age;
	@SuppressWarnings("unused")
	private SelectItem option;
	@SuppressWarnings("unused")
	private SelectItem[] multiplicity;
	@SuppressWarnings("unused")
	private SelectItem[] options;
	@SuppressWarnings("unused")
	private String ident;
	private HtmlCommandButton button;
	private HtmlCommandButton button2;

	@SuppressWarnings("unused")
	private char znak;

	@SuppressWarnings("unused")
	private LinkedHashMap<String, Object> map;

	private HtmlCommandButton downloadButton = null;

	private HtmlSelectBooleanCheckbox accepted = null;

	public BB() {

		DoubleRangeValidator validator = new DoubleRangeValidator();
		validator.setMinimum(10);
		if (price == null)
			price = new HtmlInputText();
		price.addValidator(validator);
	}
	public void zatwierdz(ActionEvent action){
		FacesContext context = FacesContext.getCurrentInstance();
		UIViewRoot view = context.getViewRoot();
		HtmlOutputText output =
			(HtmlOutputText)view.findComponent("formId:outputText");
		output.setStyle("color:blue");
		output.setValue("Dane zatwierdzone");
		HtmlCommandButton cancel =
			(HtmlCommandButton)view.findComponent("formId:cancelId");
		cancel.setRendered(false);

	}

	public void changeLocale(ActionEvent event) {
		FacesContext context = FacesContext.getCurrentInstance();
		String language = context.getExternalContext().getRequestParameterMap()
				.get("locale");
		if (language != null)
			context.getViewRoot().setLocale(new Locale(language));
	}

	public String echo() {
		FacesContext ctx = FacesContext.getCurrentInstance();
		UIViewRoot view = ctx.getViewRoot();
		Application app=ctx.getApplication();
		HtmlForm form = (HtmlForm) view.findComponent("formId");
		HtmlOutputText text = (HtmlOutputText) app.createComponent(HtmlOutputText.COMPONENT_TYPE);
		text.setValue("Echo ");
		form.getChildren().add(text);
		return null;
	}

	public HtmlSelectBooleanCheckbox getAccepted() {
		return accepted;
	}

	public int getAge() {
		return age;
	}

	public HtmlCommandButton getButton() {
		if (button == null) {
			FacesContext ctx =   FacesContext.getCurrentInstance(); 
			Application app = FacesContext.getCurrentInstance()
					.getApplication();
			button = (HtmlCommandButton) app
					.createComponent(HtmlCommandButton.COMPONENT_TYPE);
			ExpressionFactory factory = ctx.getApplication().getExpressionFactory();
			ValueExpression expression = factory.createValueExpression(ctx
			 .getELContext(), "#{bB.button2}", HtmlCommandButton.class);
			HtmlCommandButton button2 = (HtmlCommandButton) app
			.createComponent(expression, ctx, HtmlCommandButton.COMPONENT_TYPE);
			button2.setValue("drugi");
			button.setValue("Zatwierd");
		
		}
		return button;
	}

	public HtmlCommandButton getButton2() {
		return button2;
	}

	public Date getDate() {
		return date;
	}

	public HtmlCommandButton getDownloadButton() {
		return downloadButton;
	}

	public String getEmail() {
		return email;
	}

	public String getIdent() {
		UIViewRoot view = FacesContext.getCurrentInstance().getViewRoot();
		List<UIComponent> a = view.getChildren();
		StringBuffer buffer = new StringBuffer();
		for (UIComponent text : a) {

			buffer.append(text.getId() + "  ");
		}
		buffer.append(UIViewRoot.UNIQUE_ID_PREFIX + "  ");
		buffer.append(view.getId() + "  ");
		return buffer.toString();
	}

	@SuppressWarnings("unchecked")
	public LinkedHashMap<String, String> getMap() {
		Map options = new LinkedHashMap<String, String>();
		options.put("0", "0");
		options.put("1", "1");
		options.put("wicej", "*");
		return (LinkedHashMap<String, String>) options;
	}

	public SelectItem[] getMultiplicity() {
		SelectItem[] multi = { new SelectItem("0"), new SelectItem("1"),
				new SelectItem("*", "wicej") };
		return multi;
	}

	public int getNumber() {
		return number;
	}

	public String getOpcje() {
		return opcje;
	}

	public SelectItem getOption() {
		return new SelectItem("*", "wicej");
	}

	public SelectItem[] getOptions() {
		SelectItem[] direction = { new SelectItem("uni", "->"),
				new SelectItem("bi", "<-->"), };
		SelectItem[] multi = { new SelectItem("0"), new SelectItem("1"),
				new SelectItem("*", "wicej") };
		SelectItemGroup directionGroup = new SelectItemGroup("Kierunek", null,
				false, direction);
		SelectItemGroup multiGroup = new SelectItemGroup("Liczebno", null,
				false, multi);
		SelectItem[] options = { directionGroup, multiGroup };
		return options;
	}

	public HtmlInputText getPrice() {
		return price;
	}

	public Double getTotal() {
		return total;
	}

	public ZipCode getZipCode() {
		return zipCode;
	}

	public char getZnak() {

		return '\u003a';
	}

	public void init(PhaseEvent event) {
		if (! event.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) return;
		System.out.print(event.getPhaseId()+"initMethodbefora");
		FacesContext ctx = FacesContext.getCurrentInstance();
		UIViewRoot view = ctx.getViewRoot();
		Application app=ctx.getApplication();	
		List<UIComponent> list = view.getChildren();
		if (list.isEmpty()) {
			HtmlForm form =(HtmlForm) app.createComponent(HtmlForm.COMPONENT_TYPE);
			form.setId("formId");		
			HtmlCommandButton button = (HtmlCommandButton) app.createComponent(HtmlCommandButton.COMPONENT_TYPE);
			button.setValue("Zatwierd");
			button.setId("buttonId");
			ExpressionFactory factory = app.getExpressionFactory();
			MethodExpression method = factory.createMethodExpression(ctx
					.getELContext(), "#{bB.echo}", null, new Class[] {});
			button.setActionExpression(method);
			form.getChildren().add(button);
			list.add(form);
		}

	}

	public boolean isGender() {
		return gender;
	}

	public void setAccepted(HtmlSelectBooleanCheckbox accepted) {
		this.accepted = accepted;
	}

	public void setAge(int age) {
		this.age = age;
	}

	public void setButton(HtmlCommandButton button) {
		this.button = button;
	}

	public void setButton2(HtmlCommandButton button2) {
		this.button2 = button2;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public void setDownloadButton(HtmlCommandButton downloadButton) {
		this.downloadButton = downloadButton;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public void setGender(boolean gender) {
		this.gender = gender;
	}

	public void setIdent(String ident) {
		this.ident = ident;
	}

	public void setMap(LinkedHashMap<String, Object> map) {
		this.map = map;
	}

	public void setMultiplicity(SelectItem[] multiplicity) {
		this.multiplicity = multiplicity;
	}

	public void setNumber(int number) {
		this.number = number;
	}

	public void setOpcje(String opcje) {
		this.opcje = opcje;
	}
	public void setOption(SelectItem option) {
		this.option = option;
	}

	public void setPrice(HtmlInputText price) {
		this.price = price;
	}

	public void setTotal(Double total) {
		this.total = total;
	}

	public void setZipCode(ZipCode zipCode) {
		this.zipCode = zipCode;
	}

	public void setZnak(char znak) {
		this.znak = znak;
	}

	public void submit(ActionEvent event) {

	}

	public void valueChangeListener(ValueChangeEvent valueChangeEvent) {
		if (valueChangeEvent.getNewValue().equals(true))
			downloadButton.setDisabled(false);
		else
			downloadButton.setDisabled(true);
		FacesContext.getCurrentInstance().getExternalContext().log(
				"valuechange");
		FacesContext.getCurrentInstance().renderResponse();

	}

	public void valueChangeListener2(ValueChangeEvent valueChangeEvent) {
		ActionEvent action = new ActionEvent(price);
		action.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
		action.processListener(new ActionListener() {
			public void processAction(ActionEvent arg0)
					throws AbortProcessingException {
				FacesContext.getCurrentInstance().getExternalContext().log(
						"valuechange");

			}
		});
		action.getComponent().queueEvent(action);
		FacesContext.getCurrentInstance().getExternalContext().log(
				"valuechange");

	}
}
