package various.converter;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.webapp.ConverterELTag;
import javax.servlet.jsp.JspException;

/**
 * Klasa obsugi znacznika konwertera kodw pocztowych (patrz rozdzial 5.3)
 */
public class ZipCodeConverterTag extends ConverterELTag {

	private static final long serialVersionUID = 1L;
	private ValueExpression separator;

	public ValueExpression getSeparator() {
		return separator;
	}
	public void setSeparator(ValueExpression separator) {
		this.separator = separator;
	}
	
	public Converter createConverter() throws JspException {
		ZipCodeConverter converter = new ZipCodeConverter();
		ELContext elContext = FacesContext.getCurrentInstance().getELContext();
		converter.setSeparator((String) separator.getValue(elContext));
		return converter;

	}
	public void release() {
		 separator = null;
		 }
	
	
}
