/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.equalvalidator;

import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.validator.ValidatorBase;

public abstract class AbstractEqualValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.validator.Equal";
    public static final String EQUAL_MESSAGE_ID = "org.apache.myfaces.Equal.INVALID";

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        Object foreignValue;
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        UIComponent foreignComp = uiComponent.getParent().findComponent(this.getFor());
        if (foreignComp == null) {
            throw new FacesException("Unable to find component '" + this.getFor() + "' (calling findComponent on component '" + uiComponent.getId() + "')");
        }
        if (!(foreignComp instanceof EditableValueHolder)) {
            throw new FacesException("Component '" + foreignComp.getId() + "' does not implement EditableValueHolder");
        }
        EditableValueHolder foreignEditableValueHolder = (EditableValueHolder)foreignComp;
        if (foreignEditableValueHolder.isRequired() && foreignEditableValueHolder.getValue() == null) {
            return;
        }
        if (foreignEditableValueHolder.isValid()) {
            foreignValue = foreignEditableValueHolder.getValue();
        } else {
            try {
                foreignValue = this.getConvertedValueNonValid(facesContext, foreignComp);
            }
            catch (ConverterException e) {
                return;
            }
        }
        if (null == foreignValue) {
            return;
        }
        Object[] args = new Object[]{value.toString(), foreignValue == null ? foreignComp.getId() : foreignValue.toString()};
        if (foreignEditableValueHolder.getValue() == null || !foreignValue.toString().equals(value.toString())) {
            throw new ValidatorException(this.getFacesMessage(EQUAL_MESSAGE_ID, args));
        }
    }

    protected Renderer getRenderer(FacesContext context, UIComponent foreignComponent) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        String rendererType = foreignComponent.getRendererType();
        if (rendererType == null) {
            return null;
        }
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkf.getRenderKit(context, renderKitId);
        Renderer renderer = renderKit.getRenderer(foreignComponent.getFamily(), rendererType);
        if (renderer == null) {
            this.getFacesContext().getExternalContext().log("No Renderer found for component " + foreignComponent + " (component-family=" + foreignComponent.getFamily() + ", renderer-type=" + rendererType + ")");
        }
        return renderer;
    }

    protected Converter findUIOutputConverter(FacesContext facesContext, UIComponent component) {
        Converter converter = ((EditableValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if (String.class.equals((Object)valueType)) {
            return null;
        }
        if (Object.class.equals((Object)valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            this.getFacesContext().getExternalContext().log("No Converter for type " + valueType.getName() + " found", (Throwable)e);
            return null;
        }
    }

    protected Object getConvertedValueNonValid(FacesContext facesContext, UIComponent component) throws ConverterException {
        Converter converter;
        Renderer renderer;
        Object submittedValue = ((EditableValueHolder)component).getSubmittedValue();
        Object componentValueObject = submittedValue == null ? null : ((renderer = this.getRenderer(facesContext, component)) != null ? renderer.getConvertedValue(facesContext, component, submittedValue) : (submittedValue instanceof String ? ((converter = this.findUIOutputConverter(facesContext, component)) != null ? converter.getAsObject(facesContext, component, (String)submittedValue) : submittedValue) : submittedValue));
        return componentValueObject;
    }

    public abstract String getFor();

    public abstract void setFor(String var1);
}

