/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.taglib;

import java.io.IOException;
import java.io.Reader;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.taglib.UIComponentBodyTagBase;
import org.apache.myfaces.shared_tomahawk.taglib.UIComponentELTagUtils;
import org.apache.myfaces.shared_tomahawk.taglib.UIComponentTagUtils;

public abstract class UIComponentBodyELTagBase
extends UIComponentELTag {
    private static final Log log = LogFactory.getLog(UIComponentBodyTagBase.class);
    private ValueExpression _forceId;
    private ValueExpression _forceIdIndex;
    private static final Boolean DEFAULT_FORCE_ID_INDEX_VALUE = Boolean.TRUE;
    private ValueExpression _value;
    private ValueExpression _converter;

    public int doEndTag() throws JspException {
        UIComponent component;
        if (log.isWarnEnabled() && (component = this.getComponentInstance()) != null && component.getRendersChildren() && !this.isBodyContentEmpty()) {
            log.warn((Object)("Component with id '" + component.getClientId(this.getFacesContext()) + "' (" + ((Object)((Object)this)).getClass().getName() + " tag) and path : " + RendererUtils.getPathToComponent(component) + "renders it's children, but has embedded JSP or HTML code. Use the <f:verbatim> tag for nested HTML. For comments use <%/* */%> style JSP comments instead of <!-- --> style HTML comments." + "\n BodyContent:\n" + this.getBodyContent().getString().trim()));
        }
        return super.doEndTag();
    }

    private boolean isBodyContentEmpty() {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent == null) {
            return true;
        }
        try {
            int c;
            Reader reader = bodyContent.getReader();
            while ((c = reader.read()) != -1) {
                if (Character.isWhitespace((char)c)) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Error inspecting BodyContent", (Throwable)e);
            return false;
        }
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        this.setBooleanProperty(component, "forceId", this._forceId);
        this.setBooleanProperty(component, "forceIdIndex", this._forceIdIndex, DEFAULT_FORCE_ID_INDEX_VALUE);
        this.setValueProperty(component, this._value);
        this.setConverterProperty(component, this._converter);
    }

    public void setForceId(ValueExpression aForceId) {
        this._forceId = aForceId;
    }

    public void setForceIdIndex(ValueExpression aForceIdIndex) {
        this._forceIdIndex = aForceIdIndex;
    }

    public void setValue(ValueExpression value) {
        this._value = value;
    }

    public void setConverter(ValueExpression converter) {
        this._converter = converter;
    }

    protected void setIntegerProperty(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setIntegerProperty(component, propName, value);
    }

    @Deprecated
    protected void setIntegerProperty(UIComponent component, String propName, String value) {
        UIComponentTagUtils.setIntegerProperty(this.getFacesContext(), component, propName, value);
    }

    protected void setStringProperty(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setStringProperty(component, propName, value);
    }

    @Deprecated
    protected void setStringProperty(UIComponent component, String propName, String value) {
        UIComponentTagUtils.setStringProperty(this.getFacesContext(), component, propName, value);
    }

    protected void setBooleanProperty(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setBooleanProperty(component, propName, value);
    }

    protected void setBooleanProperty(UIComponent component, String propName, ValueExpression value, Boolean defaultValue) {
        UIComponentELTagUtils.setBooleanProperty(component, propName, value, defaultValue);
    }

    @Deprecated
    protected void setBooleanProperty(UIComponent component, String propName, String value) {
        UIComponentTagUtils.setBooleanProperty(this.getFacesContext(), component, propName, value);
    }

    private void setValueProperty(UIComponent component, ValueExpression value) {
        UIComponentELTagUtils.setValueProperty(this.getFacesContext(), component, value);
    }

    @Deprecated
    protected void setValueProperty(UIComponent component, String value) {
        UIComponentTagUtils.setValueProperty(this.getFacesContext(), component, value);
    }

    private void setConverterProperty(UIComponent component, ValueExpression value) {
        UIComponentELTagUtils.setConverterProperty(this.getFacesContext(), component, value);
    }

    @Deprecated
    private void setConverterProperty(UIComponent component, String value) {
        UIComponentTagUtils.setConverterProperty(this.getFacesContext(), component, value);
    }

    protected void addValidatorProperty(UIComponent component, MethodExpression value) {
        UIComponentELTagUtils.addValidatorProperty(this.getFacesContext(), component, value);
    }

    @Deprecated
    protected void setValidatorProperty(UIComponent component, String value) {
        UIComponentTagUtils.setValidatorProperty(this.getFacesContext(), component, value);
    }

    protected void setActionProperty(UIComponent component, MethodExpression action) {
        UIComponentELTagUtils.setActionProperty(this.getFacesContext(), component, action);
    }

    @Deprecated
    protected void setActionProperty(UIComponent component, String action) {
        UIComponentTagUtils.setActionProperty(this.getFacesContext(), component, action);
    }

    protected void setActionListenerProperty(UIComponent component, MethodExpression actionListener) {
        UIComponentELTagUtils.addActionListenerProperty(this.getFacesContext(), component, actionListener);
    }

    @Deprecated
    protected void setActionListenerProperty(UIComponent component, String actionListener) {
        UIComponentTagUtils.setActionListenerProperty(this.getFacesContext(), component, actionListener);
    }

    protected void addValueChangedListenerProperty(UIComponent component, MethodExpression valueChangedListener) {
        UIComponentELTagUtils.addValueChangedListenerProperty(this.getFacesContext(), component, valueChangedListener);
    }

    @Deprecated
    protected void setValueChangedListenerProperty(UIComponent component, String valueChangedListener) {
        UIComponentTagUtils.setValueChangedListenerProperty(this.getFacesContext(), component, valueChangedListener);
    }

    protected void setValueBinding(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setValueBinding(this.getFacesContext(), component, propName, value);
    }
}

