/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;

abstract class Token {
    TokenType type;

    private Token() {
    }

    String tokenType() {
        return this.getClass().getSimpleName();
    }

    boolean isDoctype() {
        return this.type == TokenType.Doctype;
    }

    Doctype asDoctype() {
        return (Doctype)this;
    }

    boolean isStartTag() {
        return this.type == TokenType.StartTag;
    }

    StartTag asStartTag() {
        return (StartTag)this;
    }

    boolean isEndTag() {
        return this.type == TokenType.EndTag;
    }

    EndTag asEndTag() {
        return (EndTag)this;
    }

    boolean isComment() {
        return this.type == TokenType.Comment;
    }

    Comment asComment() {
        return (Comment)this;
    }

    boolean isCharacter() {
        return this.type == TokenType.Character;
    }

    Character asCharacter() {
        return (Character)this;
    }

    boolean isEOF() {
        return this.type == TokenType.EOF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TokenType {
        Doctype,
        StartTag,
        EndTag,
        Comment,
        Character,
        EOF;

    }

    static class EOF
    extends Token {
        EOF() {
            this.type = TokenType.EOF;
        }
    }

    static class Character
    extends Token {
        private final String data;

        Character(String data) {
            this.type = TokenType.Character;
            this.data = data;
        }

        String getData() {
            return this.data;
        }

        public String toString() {
            return this.getData();
        }
    }

    static class Comment
    extends Token {
        final StringBuilder data = new StringBuilder();
        boolean bogus = false;

        Comment() {
            this.type = TokenType.Comment;
        }

        String getData() {
            return this.data.toString();
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    static class EndTag
    extends Tag {
        EndTag() {
            this.type = TokenType.EndTag;
        }

        EndTag(String name) {
            this();
            this.tagName = name;
        }

        public String toString() {
            return "</" + this.name() + ">";
        }
    }

    static class StartTag
    extends Tag {
        StartTag() {
            this.attributes = new Attributes();
            this.type = TokenType.StartTag;
        }

        StartTag(String name) {
            this();
            this.tagName = name;
        }

        StartTag(String name, Attributes attributes) {
            this();
            this.tagName = name;
            this.attributes = attributes;
        }

        public String toString() {
            if (this.attributes != null && this.attributes.size() > 0) {
                return "<" + this.name() + " " + this.attributes.toString() + ">";
            }
            return "<" + this.name() + ">";
        }
    }

    static abstract class Tag
    extends Token {
        protected String tagName;
        private String pendingAttributeName;
        private StringBuilder pendingAttributeValue;
        boolean selfClosing = false;
        Attributes attributes;

        Tag() {
        }

        void newAttribute() {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            if (this.pendingAttributeName != null) {
                Attribute attribute = this.pendingAttributeValue == null ? new Attribute(this.pendingAttributeName, "") : new Attribute(this.pendingAttributeName, this.pendingAttributeValue.toString());
                this.attributes.put(attribute);
            }
            this.pendingAttributeName = null;
            if (this.pendingAttributeValue != null) {
                this.pendingAttributeValue.delete(0, this.pendingAttributeValue.length());
            }
        }

        void finaliseTag() {
            if (this.pendingAttributeName != null) {
                this.newAttribute();
            }
        }

        String name() {
            Validate.isFalse(this.tagName.length() == 0);
            return this.tagName;
        }

        Tag name(String name) {
            this.tagName = name;
            return this;
        }

        boolean isSelfClosing() {
            return this.selfClosing;
        }

        Attributes getAttributes() {
            return this.attributes;
        }

        void appendTagName(String append) {
            this.tagName = this.tagName == null ? append : this.tagName.concat(append);
        }

        void appendTagName(char append) {
            this.appendTagName(String.valueOf(append));
        }

        void appendAttributeName(String append) {
            this.pendingAttributeName = this.pendingAttributeName == null ? append : this.pendingAttributeName.concat(append);
        }

        void appendAttributeName(char append) {
            this.appendAttributeName(String.valueOf(append));
        }

        void appendAttributeValue(String append) {
            this.ensureAttributeValue();
            this.pendingAttributeValue.append(append);
        }

        void appendAttributeValue(char append) {
            this.ensureAttributeValue();
            this.pendingAttributeValue.append(append);
        }

        void appendAttributeValue(char[] append) {
            this.ensureAttributeValue();
            this.pendingAttributeValue.append(append);
        }

        private final void ensureAttributeValue() {
            if (this.pendingAttributeValue == null) {
                this.pendingAttributeValue = new StringBuilder();
            }
        }
    }

    static class Doctype
    extends Token {
        final StringBuilder name = new StringBuilder();
        final StringBuilder publicIdentifier = new StringBuilder();
        final StringBuilder systemIdentifier = new StringBuilder();
        boolean forceQuirks = false;

        Doctype() {
            this.type = TokenType.Doctype;
        }

        String getName() {
            return this.name.toString();
        }

        String getPublicIdentifier() {
            return this.publicIdentifier.toString();
        }

        public String getSystemIdentifier() {
            return this.systemIdentifier.toString();
        }

        public boolean isForceQuirks() {
            return this.forceQuirks;
        }
    }
}

