/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitbutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.menuitem.UIMenuItem;
import org.primefaces.component.separator.UISeparator;
import org.primefaces.component.splitbutton.SplitButton;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class SplitButtonRenderer
extends OutcomeTargetRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String param;
        SplitButton button = (SplitButton)component;
        if (button.isDisabled()) {
            return;
        }
        String clientId = button.getClientId(context);
        String string = param = button.isAjax() ? clientId : clientId + "_button";
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SplitButton button = (SplitButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SplitButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String menuId = clientId + "_menu";
        String menuButtonId = clientId + "_menuButton";
        String buttonId = clientId + "_button";
        String styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-splitbutton ui-buttonset ui-widget" : "ui-splitbutton ui-buttonset ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "id");
        }
        this.encodeDefaultButton(context, button, buttonId);
        this.encodeMenuIcon(context, button, menuButtonId);
        this.encodeMenu(context, button, menuId);
        writer.endElement("div");
    }

    protected void encodeDefaultButton(FacesContext context, SplitButton button, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String value = (String)button.getValue();
        String icon = button.getIcon();
        String onclick = this.buildOnclick(context, button);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("name", (Object)id, "name");
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        if (onclick.length() > 0) {
            writer.writeAttribute("onclick", (Object)onclick.toString(), "onclick");
        }
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (icon != null && !icon.trim().equals("")) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (value == null) {
            writer.write("ui-button");
        } else {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMenuIcon(FacesContext context, SplitButton button, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String buttonClass = "ui-splitbutton-menubutton  ui-button ui-widget ui-state-default ui-corner-right ui-button-icon-only";
        if (button.isDisabled()) {
            buttonClass = buttonClass + " ui-state-disabled";
        }
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)buttonClass, null);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, SplitButton button) throws IOException {
        String clientId = button.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("SplitButton", button.resolveWidgetVar(), clientId);
        wb.finish();
    }

    protected String buildOnclick(FacesContext context, SplitButton button) throws IOException {
        StringBuilder onclick = new StringBuilder();
        if (button.getOnclick() != null) {
            onclick.append(button.getOnclick()).append(";");
        }
        if (button.isAjax()) {
            onclick.append(this.buildAjaxRequest(context, button, null));
        } else {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)button);
            if (form == null) {
                throw new FacesException("SplitButton : \"" + button.getClientId(context) + "\" must be inside a form element");
            }
            onclick.append(this.buildNonAjaxRequest(context, (UIComponent)button, form, null, false));
        }
        String onclickBehaviors = this.getEventBehaviors(context, (ClientBehaviorHolder)button, "click");
        if (onclickBehaviors != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        return onclick.toString();
    }

    protected void encodeMenu(FacesContext context, SplitButton button, String menuId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)menuId, null);
        writer.writeAttribute("class", (Object)"ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow", "styleClass");
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", "styleClass");
        for (UIComponent child : button.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof UIMenuItem) {
                UIMenuItem item = (UIMenuItem)child;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, item);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof UISeparator)) continue;
            this.encodeSeparator(context, (UISeparator)child);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuItem(FacesContext context, UIMenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuitem.getIcon();
        String title = menuitem.getTitle();
        if (menuitem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuitem);
        } else {
            String styleClass;
            boolean disabled = menuitem.isDisabled();
            writer.startElement("a", null);
            if (title != null) {
                writer.writeAttribute("title", (Object)title, null);
            }
            styleClass = (styleClass = menuitem.getStyleClass()) == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
            styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
            writer.writeAttribute("class", (Object)styleClass, null);
            if (menuitem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuitem.getStyle(), null);
            }
            if (disabled) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
            } else {
                String onclick = menuitem.getOnclick();
                if (menuitem.getUrl() != null || menuitem.getOutcome() != null) {
                    String targetURL = this.getTargetURL(context, menuitem);
                    writer.writeAttribute("href", (Object)targetURL, null);
                    if (menuitem.getTarget() != null) {
                        writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
                    }
                } else {
                    writer.writeAttribute("href", (Object)"#", null);
                    UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuitem);
                    if (form == null) {
                        throw new FacesException("MenuItem must be inside a form element");
                    }
                    String command = menuitem.isAjax() ? this.buildAjaxRequest(context, menuitem, form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, form, menuitem.getClientId(context), true);
                    String string = onclick = onclick == null ? command : onclick + ";" + command;
                }
                if (onclick != null) {
                    writer.writeAttribute("onclick", (Object)onclick, null);
                }
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
                writer.endElement("span");
            }
            if (menuitem.getValue() != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
                writer.writeText((Object)((String)menuitem.getValue()), "value");
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    protected void encodeSeparator(FacesContext context, UISeparator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default" : "ui-separator ui-state-default " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

