/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.behavior.ajax;

import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import org.primefaces.component.behavior.ajax.AjaxBehavior;
import org.primefaces.context.RequestContext;
import org.primefaces.util.AjaxRequestBuilder;

public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (!ajaxBehavior.isDisabled()) {
            AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)behavior);
            PhaseId phaseId = this.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
            event.setPhaseId(phaseId);
            component.queueEvent((FacesEvent)event);
        }
    }

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        UIComponent component = behaviorContext.getComponent();
        String source = behaviorContext.getSourceId();
        String process = ajaxBehavior.getProcess();
        if (process == null) {
            process = "@this";
        }
        AjaxRequestBuilder builder = RequestContext.getCurrentInstance().getAjaxRequestBuilder();
        String request = builder.init().source(source).event(behaviorContext.getEventName()).process(component, process).update(component, ajaxBehavior.getUpdate()).async(ajaxBehavior.isAsync()).global(ajaxBehavior.isGlobal()).partialSubmit(ajaxBehavior.isPartialSubmit(), ajaxBehavior.isPartialSubmitSet()).resetValues(ajaxBehavior.isResetValues(), ajaxBehavior.isResetValuesSet()).ignoreAutoUpdate(ajaxBehavior.isIgnoreAutoUpdate()).onstart(ajaxBehavior.getOnstart()).onerror(ajaxBehavior.getOnerror()).onsuccess(ajaxBehavior.getOnsuccess()).oncomplete(ajaxBehavior.getOncomplete()).params(component).buildBehavior();
        return request;
    }

    private boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = false;
        if (ajaxBehavior.isImmediateSet()) {
            immediate = ajaxBehavior.isImmediate();
        } else if (component instanceof EditableValueHolder) {
            immediate = ((EditableValueHolder)component).isImmediate();
        } else if (component instanceof ActionSource) {
            immediate = ((ActionSource)component).isImmediate();
        }
        return immediate;
    }
}

