/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.application.ResourceWrapper;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public class CDNResourceHandler
extends ResourceHandlerWrapper {
    public static final String PARAM_NAME_CDN_RESOURCES = "org.omnifaces.CDN_RESOURCE_HANDLER_URLS";
    public static final String PARAM_NAME_CDN_DEV_STAGE = "org.omnifaces.CDN_RESOURCE_HANDLER_ALWAYS_ENABLED";
    private static final String ERROR_MISSING_INIT_PARAM = "Context parameter 'org.omnifaces.CDN_RESOURCE_HANDLER_URLS' is missing in web.xml or web-fragment.xml.";
    private static final String ERROR_INVALID_INIT_PARAM = "Context parameter 'org.omnifaces.CDN_RESOURCE_HANDLER_URLS' is in invalid syntax. It must follow 'resourceId=URL,resourceId=URL,resourceId=URL' syntax.";
    private static final String ERROR_INVALID_WILDCARD = "Context parameter 'org.omnifaces.CDN_RESOURCE_HANDLER_URLS' is in invalid syntax. Wildcard can only represent entire resource name '*' and URL suffix '/*' as in 'libraryName:*=http://cdn.example.com/*'.";
    private ResourceHandler wrapped;
    private Map<ResourceIdentifier, String> cdnResources;

    public CDNResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
        if (!Faces.isDevelopment() || "true".equals(Faces.getInitParameter(PARAM_NAME_CDN_DEV_STAGE))) {
            this.cdnResources = CDNResourceHandler.initCDNResources();
            if (this.cdnResources == null) {
                throw new IllegalArgumentException(ERROR_MISSING_INIT_PARAM);
            }
        }
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        String requestPath = null;
        if (this.cdnResources != null && (requestPath = this.cdnResources.get(new ResourceIdentifier(libraryName, resourceName))) == null && (requestPath = this.cdnResources.get(new ResourceIdentifier(libraryName, "*"))) != null) {
            requestPath = requestPath.substring(0, requestPath.length() - 1) + resourceName;
        }
        if (requestPath == null) {
            return this.getWrapped().createResource(resourceName, libraryName, contentType);
        }
        final String finalRequestPath = (String)Faces.evaluateExpressionGet(requestPath);
        return new ResourceWrapper(){

            public String getRequestPath() {
                return finalRequestPath;
            }

            public Resource getWrapped() {
                return null;
            }
        };
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    static Map<ResourceIdentifier, String> initCDNResources() {
        String cdnResourcesParam = Faces.getInitParameter(PARAM_NAME_CDN_RESOURCES);
        if (Utils.isEmpty(cdnResourcesParam)) {
            return null;
        }
        HashMap<ResourceIdentifier, String> cdnResources = new HashMap<ResourceIdentifier, String>();
        for (String cdnResource : cdnResourcesParam.split("\\s*,\\s*")) {
            String[] cdnResourceIdAndURL = cdnResource.split("\\s*=\\s*", 2);
            if (cdnResourceIdAndURL.length != 2) {
                throw new IllegalArgumentException(ERROR_INVALID_INIT_PARAM);
            }
            ResourceIdentifier id = new ResourceIdentifier(cdnResourceIdAndURL[0]);
            if (!(!id.getName().contains("*") || id.getName().equals("*") && cdnResourceIdAndURL[1].endsWith("/*"))) {
                throw new IllegalArgumentException(ERROR_INVALID_WILDCARD);
            }
            cdnResources.put(id, cdnResourceIdAndURL[1]);
        }
        return cdnResources;
    }
}

