/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.model.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.omnifaces.model.tree.TreeModel;

public abstract class AbstractTreeModel<T>
implements TreeModel<T> {
    private static final long serialVersionUID = 6627109279123441287L;
    private T data;
    private AbstractTreeModel<T> parent;
    private Collection<TreeModel<T>> children;
    private List<TreeModel<T>> unmodifiableChildren = Collections.emptyList();
    private int index;

    protected abstract Collection<TreeModel<T>> createChildren();

    @Override
    public void setData(T data) {
        this.data = data;
    }

    @Override
    public TreeModel<T> addChild(T data) {
        AbstractTreeModel child;
        try {
            child = (AbstractTreeModel)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
        child.data = data;
        return this.addChildNode(child);
    }

    @Override
    public TreeModel<T> addChildNode(TreeModel<T> child) {
        if (child == null || child.getClass() != this.getClass()) {
            throw new IllegalArgumentException();
        }
        if (this.children == null) {
            this.children = this.createChildren();
        }
        ((AbstractTreeModel)child).parent = this;
        ((AbstractTreeModel)child).index = this.children.size();
        this.children.add(child);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeModel<T> remove() {
        if (this.parent != null) {
            Collection<TreeModel<T>> collection = this.parent.children;
            synchronized (collection) {
                this.parent.children.remove(this);
                int index = 0;
                for (TreeModel<T> child : this.parent.children) {
                    ((AbstractTreeModel)child).index = index++;
                }
            }
        }
        return this.parent;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public TreeModel<T> getParent() {
        return this.parent;
    }

    @Override
    public TreeModel<T> getNextSibling() {
        return this.getNextSibling(this.parent, this.index + 1);
    }

    private TreeModel<T> getNextSibling(TreeModel<T> parent, int index) {
        if (parent == null) {
            return null;
        }
        if (index < parent.getChildCount()) {
            return parent.getChildren().get(index);
        }
        return this.getNextSibling(parent.getNextSibling(), 0);
    }

    @Override
    public TreeModel<T> getPreviousSibling() {
        return this.getPreviousSibling(this.parent, this.index - 1);
    }

    private TreeModel<T> getPreviousSibling(TreeModel<T> parent, int index) {
        if (parent == null) {
            return null;
        }
        if (index >= 0) {
            return parent.getChildren().get(index);
        }
        return this.getPreviousSibling(parent, ((parent = parent.getPreviousSibling()) != null ? parent.getChildCount() : 0) - 1);
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public List<TreeModel<T>> getChildren() {
        if (this.unmodifiableChildren.size() != this.getChildCount()) {
            this.unmodifiableChildren = Collections.unmodifiableList(this.children instanceof List ? (List)this.children : new ArrayList<TreeModel<T>>(this.children));
        }
        return this.unmodifiableChildren;
    }

    @Override
    public Iterator<TreeModel<T>> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    @Override
    public String getIndex() {
        return this.parent == null ? null : (this.parent.parent == null ? "" : this.parent.getIndex() + "_") + this.index;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean isFirst() {
        return this.parent != null && this.index == 0;
    }

    @Override
    public boolean isLast() {
        return this.parent != null && this.index + 1 == this.parent.getChildCount();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        AbstractTreeModel other = (AbstractTreeModel)object;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.children == null ? other.children != null : !this.children.equals(other.children));
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.children == null ? 0 : this.children.hashCode());
        hashCode = 31 * hashCode + (this.data == null ? 0 : this.data.hashCode());
        hashCode = 31 * hashCode + (this.parent == null ? 0 : this.parent.hashCode());
        return hashCode;
    }

    public String toString() {
        return (this.data == null ? "" : this.data) + "" + (this.children == null ? "" : this.children);
    }
}

