/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.primefaces.config.ConfigContainer;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxRequestBuilder {
    protected StringBuilder buffer;
    protected FacesContext context;
    private boolean preventDefault = false;

    public AjaxRequestBuilder(FacesContext context) {
        this.context = context;
        this.buffer = new StringBuilder();
    }

    public AjaxRequestBuilder init() {
        this.buffer.append("PrimeFaces.ab({");
        return this;
    }

    public AjaxRequestBuilder source(String source) {
        if (source != null) {
            this.buffer.append("source:").append("'").append(source).append("'");
        } else {
            this.buffer.append("source:").append("this");
        }
        return this;
    }

    public AjaxRequestBuilder form(String form) {
        if (form != null) {
            this.buffer.append(",formId:'").append(form).append("'");
        }
        return this;
    }

    private boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    public AjaxRequestBuilder process(UIComponent component, String expressions) {
        this.addExpressions(component, expressions, "process");
        return this;
    }

    public AjaxRequestBuilder update(UIComponent component, String expressions) {
        this.addExpressions(component, expressions, "update");
        return this;
    }

    private AjaxRequestBuilder addExpressions(UIComponent component, String expressions, String key) {
        if (!this.isValueBlank(expressions)) {
            String resolvedExpressions = SearchExpressionFacade.resolveComponentsForClient(this.context, component, expressions, true);
            this.buffer.append(",").append(key).append(":'").append(resolvedExpressions).append("'");
        }
        return this;
    }

    public AjaxRequestBuilder event(String event) {
        this.buffer.append(",event:'").append(event).append("'");
        return this;
    }

    public AjaxRequestBuilder async(boolean async) {
        if (async) {
            this.buffer.append(",async:true");
        }
        return this;
    }

    public AjaxRequestBuilder global(boolean global) {
        if (!global) {
            this.buffer.append(",global:false");
        }
        return this;
    }

    public AjaxRequestBuilder ignoreAutoUpdate(boolean ignoreAutoUpdate) {
        if (ignoreAutoUpdate) {
            this.buffer.append(",ignoreAutoUpdate:true");
        }
        return this;
    }

    public AjaxRequestBuilder partialSubmit(boolean value, boolean partialSubmitSet) {
        boolean partialSubmit;
        ConfigContainer config = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
        boolean bl = partialSubmit = partialSubmitSet ? value : config.isPartialSubmitEnabled();
        if (partialSubmit) {
            this.buffer.append(",partialSubmit:true");
        }
        return this;
    }

    public AjaxRequestBuilder resetValues(boolean value, boolean resetValuesSet) {
        boolean resetValues;
        ConfigContainer config = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
        boolean bl = resetValues = resetValuesSet ? value : config.isResetValuesEnabled();
        if (resetValues) {
            this.buffer.append(",resetValues:true");
        }
        return this;
    }

    public AjaxRequestBuilder onstart(String onstart) {
        if (onstart != null) {
            this.buffer.append(",onstart:function(cfg){").append(onstart).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onerror(String onerror) {
        if (onerror != null) {
            this.buffer.append(",onerror:function(xhr,status,error){").append(onerror).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder onsuccess(String onsuccess) {
        if (onsuccess != null) {
            this.buffer.append(",onsuccess:function(data,status,xhr){").append(onsuccess).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder oncomplete(String oncomplete) {
        if (oncomplete != null) {
            this.buffer.append(",oncomplete:function(xhr,status,args){").append(oncomplete).append(";}");
        }
        return this;
    }

    public AjaxRequestBuilder params(UIComponent component) {
        boolean paramWritten = false;
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (!paramWritten) {
                paramWritten = true;
                this.buffer.append(",params:[");
            } else {
                this.buffer.append(",");
            }
            this.buffer.append("{name:").append("'").append(parameter.getName()).append("',value:'").append(parameter.getValue()).append("'}");
        }
        if (paramWritten) {
            this.buffer.append("]");
        }
        return this;
    }

    public AjaxRequestBuilder params(Map<String, List<String>> params) {
        if (params != null && !params.isEmpty()) {
            this.buffer.append(",params:[");
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                List<String> paramValues = params.get(name);
                int size = paramValues.size();
                for (int i = 0; i < size; ++i) {
                    String paramValue = paramValues.get(i);
                    this.buffer.append("{name:").append("'").append(name).append("',value:'").append(paramValue).append("'}");
                    if (i >= size - 1) continue;
                    this.buffer.append(",");
                }
                if (!it.hasNext()) continue;
                this.buffer.append(",");
            }
            this.buffer.append("]");
        }
        return this;
    }

    public AjaxRequestBuilder passParams() {
        this.buffer.append(",params:arguments[0]");
        return this;
    }

    public AjaxRequestBuilder preventDefault() {
        this.preventDefault = true;
        return this;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String build() {
        this.addFragmentConfig();
        this.buffer.append("});");
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.reset();
        return request;
    }

    public String buildBehavior() {
        this.addFragmentConfig();
        this.buffer.append("}, arguments[1]);");
        if (this.preventDefault) {
            this.buffer.append("return false;");
        }
        String request = this.buffer.toString();
        this.reset();
        return request;
    }

    public void reset() {
        this.buffer.setLength(0);
        this.preventDefault = false;
    }

    private void addFragmentConfig() {
        Map<Object, Object> attrs = RequestContext.getCurrentInstance().getAttributes();
        Object fragmentId = attrs.get("primefaces.fragment");
        if (fragmentId != null) {
            this.buffer.append(",fragmentId:'").append(fragmentId).append("'");
            if (attrs.containsKey("primefaces.fragment.autorendered")) {
                this.buffer.append(",fragmentUpdate:true");
            }
        }
    }
}

