/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Ajax;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class Hacks {
    private static final boolean RICHFACES_INSTALLED = Hacks.initRichFacesInstalled();
    private static final boolean RICHFACES_RESOURCE_OPTIMIZATION_ENABLED = RICHFACES_INSTALLED && Boolean.valueOf(Faces.getInitParameter("org.richfaces.resourceOptimization.enabled")) != false;
    private static final String RICHFACES_PVC_CLASS_NAME = "org.richfaces.context.ExtendedPartialViewContextImpl";
    private static final String RICHFACES_RLR_RENDERER_TYPE = "org.richfaces.renderkit.ResourceLibraryRenderer";
    private static final String RICHFACES_RLF_CLASS_NAME = "org.richfaces.resource.ResourceLibraryFactoryImpl";
    private static final boolean JUEL_SUPPORTS_METHOD_EXPRESSION = Hacks.initJUELSupportsMethodExpression();
    private static final String JUEL_EF_CLASS_NAME = "de.odysseus.el.ExpressionFactoryImpl";
    private static final String JUEL_MINIMUM_METHOD_EXPRESSION_VERSION = "2.2.6";
    private static final Set<String> MOJARRA_MYFACES_RESOURCE_DEPENDENCY_KEYS = Utils.unmodifiableSet("com.sun.faces.PROCESSED_RESOURCE_DEPENDENCIES", "org.apache.myfaces.RENDERED_SCRIPT_RESOURCES_SET", "org.apache.myfaces.RENDERED_STYLESHEET_RESOURCES_SET");
    private static final String ERROR_CREATE_INSTANCE = "Cannot create instance of class '%s'.";
    private static final String ERROR_ACCESS_FIELD = "Cannot access field '%s' of class '%s'.";
    private static final String ERROR_INVOKE_METHOD = "Cannot invoke method '%s' of class '%s' with arguments %s.";
    private static final Object[] EMPTY_PARAMETERS = new Object[0];

    private Hacks() {
    }

    private static boolean initRichFacesInstalled() {
        try {
            Class.forName(RICHFACES_PVC_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    private static boolean initJUELSupportsMethodExpression() {
        Package juelPackage = Package.getPackage("de.odysseus.el");
        if (juelPackage == null) {
            return false;
        }
        String juelVersion = juelPackage.getImplementationVersion();
        if (juelVersion == null) {
            return false;
        }
        return Hacks.isSameOrHigherVersion(juelVersion, JUEL_MINIMUM_METHOD_EXPRESSION_VERSION);
    }

    public static boolean isRichFacesInstalled() {
        return RICHFACES_INSTALLED;
    }

    public static PartialViewContext getRichFacesPartialViewContext() {
        PartialViewContext context = Ajax.getContext();
        while (!context.getClass().getName().equals(RICHFACES_PVC_CLASS_NAME) && context instanceof PartialViewContextWrapper) {
            context = ((PartialViewContextWrapper)context).getWrapped();
        }
        if (context.getClass().getName().equals(RICHFACES_PVC_CLASS_NAME)) {
            return context;
        }
        return null;
    }

    public static Collection<String> getRichFacesRenderIds() {
        Collection renderIds;
        PartialViewContext richFacesContext = Hacks.getRichFacesPartialViewContext();
        if (richFacesContext != null && (renderIds = (Collection)Hacks.accessField(richFacesContext, "componentRenderIds")) != null) {
            return renderIds;
        }
        return Collections.emptyList();
    }

    public static PartialViewContext getRichFacesWrappedPartialViewContext() {
        PartialViewContext richFacesContext = Hacks.getRichFacesPartialViewContext();
        if (richFacesContext != null) {
            return (PartialViewContext)Hacks.accessField(richFacesContext, "wrappedViewContext");
        }
        return null;
    }

    public static boolean isRichFacesResourceOptimizationEnabled() {
        return RICHFACES_RESOURCE_OPTIMIZATION_ENABLED;
    }

    public static boolean isRichFacesResourceLibraryRenderer(String rendererType) {
        return RICHFACES_RLR_RENDERER_TYPE.equals(rendererType);
    }

    public static Set<ResourceIdentifier> getRichFacesResourceLibraryResources(ResourceIdentifier id) {
        Object resourceFactory = Hacks.createInstance(RICHFACES_RLF_CLASS_NAME);
        String name = id.getName().split("\\.")[0];
        Object resourceLibrary = Hacks.invokeMethod(resourceFactory, "getResourceLibrary", name, id.getLibrary());
        Iterable resources = (Iterable)Hacks.invokeMethod(resourceLibrary, "getResources", new Object[0]);
        LinkedHashSet<ResourceIdentifier> resourceIdentifiers = new LinkedHashSet<ResourceIdentifier>();
        for (Object resource : resources) {
            String libraryName = (String)Hacks.invokeMethod(resource, "getLibraryName", new Object[0]);
            String resourceName = (String)Hacks.invokeMethod(resource, "getResourceName", new Object[0]);
            resourceIdentifiers.add(new ResourceIdentifier(libraryName, resourceName));
        }
        return resourceIdentifiers;
    }

    public static boolean isJUELUsed() {
        return Hacks.isJUELUsed(Faces.getApplication().getExpressionFactory());
    }

    public static boolean isJUELUsed(ExpressionFactory factory) {
        return factory.getClass().getName().equals(JUEL_EF_CLASS_NAME);
    }

    public static boolean isJUELSupportingMethodExpression() {
        return JUEL_SUPPORTS_METHOD_EXPRESSION;
    }

    public static boolean isSameOrHigherVersion(String version1, String version2) {
        List<Integer> version1Elements = Hacks.toVersionElements(version1);
        List<Integer> version2Elements = Hacks.toVersionElements(version2);
        int maxLength = Math.max(version1Elements.size(), version2Elements.size());
        for (int i = 0; i < maxLength; ++i) {
            int version2Element;
            int version1Element = Hacks.getVersionElement(version1Elements, i);
            if (version1Element > (version2Element = Hacks.getVersionElement(version2Elements, i))) {
                return true;
            }
            if (version1Element >= version2Element) continue;
            return false;
        }
        return true;
    }

    private static List<Integer> toVersionElements(String version) {
        ArrayList<Integer> versionElements = new ArrayList<Integer>();
        for (String string : version.split("\\.")) {
            versionElements.add(Integer.valueOf(string));
        }
        return versionElements;
    }

    private static int getVersionElement(List<Integer> versionElements, int index) {
        if (index < versionElements.size()) {
            return versionElements.get(index);
        }
        return 0;
    }

    public static Method methodExpressionToStaticMethod(final ELContext context, final MethodExpression methodExpression) {
        MethodInfo methodInfo = methodExpression.getMethodInfo(FacesContext.getCurrentInstance().getELContext());
        try {
            Constructor methodConstructor = Method.class.getDeclaredConstructor(Class.class, String.class, Class[].class, Class.class, Class[].class, Integer.TYPE, Integer.TYPE, String.class, byte[].class, byte[].class, byte[].class);
            methodConstructor.setAccessible(true);
            Method staticMethod = (Method)methodConstructor.newInstance(null, methodInfo.getName(), methodInfo.getParamTypes(), methodInfo.getReturnType(), null, 0, 0, null, null, null, null);
            Class<?> methodAccessorClass = Class.forName("sun.reflect.MethodAccessor");
            Object MethodAccessor2 = Proxy.newProxyInstance(Method.class.getClassLoader(), new Class[]{methodAccessorClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object[] params = null;
                    params = args != null && args.length > 1 ? (Object[])args[1] : EMPTY_PARAMETERS;
                    return methodExpression.invoke(context, params);
                }
            });
            Method setMethodAccessor = Method.class.getDeclaredMethod("setMethodAccessor", methodAccessorClass);
            setMethodAccessor.setAccessible(true);
            setMethodAccessor.invoke((Object)staticMethod, MethodAccessor2);
            Field override = AccessibleObject.class.getDeclaredField("override");
            override.setAccessible(true);
            override.set(staticMethod, true);
            return staticMethod;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void removeResourceDependencyState(FacesContext context) {
        context.getAttributes().keySet().removeAll(MOJARRA_MYFACES_RESOURCE_DEPENDENCY_KEYS);
        context.getAttributes().values().removeAll(Collections.singleton(true));
    }

    private static Object createInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(ERROR_CREATE_INSTANCE, className), e);
        }
    }

    private static <T> T accessField(Object instance, String fieldName) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(ERROR_ACCESS_FIELD, fieldName, instance.getClass()), e);
        }
    }

    private static <T> T invokeMethod(Object instance, String methodName, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            Method method = instance.getClass().getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return (T)method.invoke(instance, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(ERROR_INVOKE_METHOD, methodName, instance.getClass(), Arrays.toString(parameters)), e);
        }
    }
}

