/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.context.RequestContext;
import org.primefaces.convert.ClientConverter;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.AjaxRequestBuilder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;
import org.primefaces.validate.bean.BeanValidationMetadata;
import org.primefaces.validate.bean.BeanValidationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreRenderer
extends Renderer {
    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (int i = 0; i < component.getChildCount(); ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                this.renderChild(context, child);
            }
        }
    }

    protected void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(context);
        if (child.getRendersChildren()) {
            child.encodeChildren(context);
        } else {
            this.renderChildren(context, child);
        }
        child.encodeEnd(context);
    }

    @Deprecated
    protected String getActionURL(FacesContext context) {
        String actionURL = context.getApplication().getViewHandler().getActionURL(context, context.getViewRoot().getViewId());
        return context.getExternalContext().encodeActionURL(actionURL);
    }

    protected String getResourceURL(FacesContext context, String value) {
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(url);
    }

    protected String getResourceRequestPath(FacesContext context, String resourceName) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceName, "primefaces");
        return resource.getRequestPath();
    }

    @Deprecated
    public boolean isPostback(FacesContext context) {
        return context.getRenderKit().getResponseStateManager().isPostback(context);
    }

    @Deprecated
    public boolean isAjaxRequest(FacesContext context) {
        return context.getPartialViewContext().isAjaxRequest();
    }

    @Deprecated
    protected void renderPassThruAttributes(FacesContext context, UIComponent component, String var, String[] attrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (String event : attrs) {
            String eventHandler = (String)component.getAttributes().get(event);
            if (eventHandler == null) continue;
            writer.write(var + ".addListener(\"" + event.substring(2, event.length()) + "\", function(e){" + eventHandler + ";});\n");
        }
    }

    protected void renderPassThruAttributes(FacesContext context, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (String attribute : attrs) {
            Object value = component.getAttributes().get(attribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isAtLeastJSF22()) {
            RendererUtils.renderPassThroughAttributes(context, component);
        }
    }

    protected void renderPassThruAttributes(FacesContext context, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isAtLeastJSF22()) {
            RendererUtils.renderPassThroughAttributes(context, component);
        }
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    public boolean isValueBlank(String value) {
        return ComponentUtils.isValueBlank(value);
    }

    protected String buildAjaxRequest(FacesContext context, AjaxSource source, UIComponent form) {
        UIComponent component = (UIComponent)source;
        String clientId = component.getClientId(context);
        AjaxRequestBuilder builder = RequestContext.getCurrentInstance().getAjaxRequestBuilder();
        builder.init().source(clientId).process(component, source.getProcess()).update(component, source.getUpdate()).async(source.isAsync()).global(source.isGlobal()).partialSubmit(source.isPartialSubmit(), source.isPartialSubmitSet()).resetValues(source.isResetValues(), source.isResetValuesSet()).ignoreAutoUpdate(source.isIgnoreAutoUpdate()).onstart(source.getOnstart()).onerror(source.getOnerror()).onsuccess(source.getOnsuccess()).oncomplete(source.getOncomplete()).params(component);
        if (form != null) {
            builder.form(form.getClientId(context));
        }
        builder.preventDefault();
        return builder.build();
    }

    protected String buildNonAjaxRequest(FacesContext context, UIComponent component, UIComponent form, String decodeParam, boolean submit) {
        StringBuilder request = new StringBuilder();
        String formId = form.getClientId(context);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (decodeParam != null) {
            params.put(decodeParam, decodeParam);
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            params.put(param.getName(), param.getValue());
        }
        if (!params.isEmpty()) {
            request.append("PrimeFaces.addSubmitParam('").append(formId).append("',{");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = params.get(key);
                request.append("'").append(key).append("':'").append(value).append("'");
                if (!it.hasNext()) continue;
                request.append(",");
            }
            request.append("})");
        }
        if (submit) {
            request.append(".submit('").append(formId).append("');return false;");
        }
        return request.toString();
    }

    protected void encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map behaviorEvents = component.getClientBehaviors();
        if (!behaviorEvents.isEmpty()) {
            String clientId = ((UIComponent)component).getClientId(context);
            List params = Collections.emptyList();
            writer.write(",behaviors:{");
            Iterator eventIterator = behaviorEvents.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event;
                String domEvent = event = (String)eventIterator.next();
                if (event.equalsIgnoreCase("valueChange")) {
                    domEvent = "change";
                } else if (event.equalsIgnoreCase("action")) {
                    domEvent = "click";
                }
                writer.write(domEvent);
                writer.write(58);
                writer.write("function(event,ext){PrimeFaces.bc(this,event,ext,[");
                List behaviorsByEvent = (List)behaviorEvents.get(event);
                int renderedBehaviors = 0;
                for (int i = 0; i < behaviorsByEvent.size(); ++i) {
                    ClientBehaviorContext cbc;
                    ClientBehavior behavior = (ClientBehavior)behaviorsByEvent.get(i);
                    String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params));
                    if (script == null) continue;
                    if (renderedBehaviors > 0) {
                        writer.write(44);
                    }
                    writer.write('\'' + this.escapeJavaScriptForChain(script) + '\'');
                    ++renderedBehaviors;
                }
                writer.write("]);}");
                if (!eventIterator.hasNext()) continue;
                writer.write(",");
            }
            writer.write("}");
        }
    }

    protected String escapeJavaScriptForChain(String javaScript) {
        StringBuilder out = null;
        for (int pos = 0; pos < javaScript.length(); ++pos) {
            char c = javaScript.charAt(pos);
            if (c == '\\' || c == '\'') {
                if (out == null) {
                    out = new StringBuilder(javaScript.length() + 8);
                    if (pos > 0) {
                        out.append(javaScript, 0, pos);
                    }
                }
                out.append('\\');
            }
            if (out == null) continue;
            out.append(c);
        }
        if (out == null) {
            return javaScript;
        }
        return out.toString();
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        List behaviorsForEvent;
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (null != behaviorEvent && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && !behaviorsForEvent.isEmpty()) {
            String behaviorSource = (String)params.get("javax.faces.source");
            String clientId = component.getClientId();
            if (behaviorSource != null && clientId.startsWith(behaviorSource)) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
        }
    }

    protected void startScript(ResponseWriter writer, String clientId) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("id", (Object)(clientId + "_s"), null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
    }

    protected void endScript(ResponseWriter writer) throws IOException {
        writer.endElement("script");
    }

    protected String escapeText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block11: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '/': {
                    sb.append("\\/");
                    continue block11;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block11;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected String getEventBehaviors(FacesContext context, ClientBehaviorHolder cbh, String event) {
        List behaviors = (List)cbh.getClientBehaviors().get(event);
        StringBuilder sb = new StringBuilder();
        if (behaviors != null && !behaviors.isEmpty()) {
            UIComponent component = (UIComponent)cbh;
            String clientId = component.getClientId(context);
            List params = Collections.emptyList();
            for (int i = 0; i < behaviors.size(); ++i) {
                ClientBehaviorContext cbc;
                ClientBehavior behavior = (ClientBehavior)behaviors.get(i);
                String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)event, (String)clientId, params));
                if (script == null) continue;
                sb.append(script).append(";");
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    protected boolean shouldWriteId(UIComponent component) {
        String id = component.getId();
        return null != id && (!id.startsWith("j_id") || component instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)component).getClientBehaviors().isEmpty());
    }

    protected WidgetBuilder getWidgetBuilder(FacesContext context) {
        return RequestContext.getCurrentInstance().getWidgetBuilder();
    }

    protected void renderValidationMetadata(FacesContext context, EditableValueHolder component) throws IOException {
        Validator[] validators;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent comp = (UIComponent)component;
        Converter converter = ComponentUtils.getConverter(context, comp);
        Map attrs = comp.getAttributes();
        Object label = attrs.get("label");
        Object requiredMessage = attrs.get("requiredMessage");
        Object validatorMessage = attrs.get("validatorMessage");
        Object converterMessage = attrs.get("converterMessage");
        ArrayList<String> validatorIds = new ArrayList<String>();
        String highlighter = this.getHighlighter();
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (label != null) {
            writer.writeAttribute("data-p-label", label, null);
        }
        if (requiredMessage != null) {
            writer.writeAttribute("data-p-rmsg", requiredMessage, null);
        }
        if (validatorMessage != null) {
            writer.writeAttribute("data-p-vmsg", validatorMessage, null);
        }
        if (converterMessage != null) {
            writer.writeAttribute("data-p-cmsg", converterMessage, null);
        }
        if (converter != null && converter instanceof ClientConverter) {
            ClientConverter clientConverter = (ClientConverter)converter;
            Map<String, Object> metadata = clientConverter.getMetadata();
            writer.writeAttribute("data-p-con", (Object)((ClientConverter)converter).getConverterId(), null);
            if (metadata != null && !metadata.isEmpty()) {
                this.renderValidationMetadataMap(context, metadata);
            }
        }
        if (requestContext.getApplicationContext().getConfig().isBeanValidationAvailable()) {
            BeanValidationMetadata beanValidationMetadata = BeanValidationResolver.resolveValidationMetadata(context, comp, requestContext);
            this.renderValidationMetadataMap(context, beanValidationMetadata.getAttributes());
            validatorIds.addAll(beanValidationMetadata.getValidatorIds());
        }
        if (component.isRequired()) {
            writer.writeAttribute("data-p-required", (Object)"true", null);
        }
        if ((validators = component.getValidators()) != null) {
            for (int i = 0; i < validators.length; ++i) {
                Validator validator = validators[i];
                if (!(validator instanceof ClientValidator)) continue;
                ClientValidator clientValidator = (ClientValidator)validator;
                validatorIds.add(clientValidator.getValidatorId());
                Map<String, Object> metadata = clientValidator.getMetadata();
                if (metadata == null || metadata.isEmpty()) continue;
                this.renderValidationMetadataMap(context, metadata);
            }
        }
        this.renderValidatorIds(context, validatorIds);
        if (highlighter != null) {
            writer.writeAttribute("data-p-hl", (Object)highlighter, null);
        }
    }

    private void renderValidationMetadataMap(FacesContext context, Map<String, Object> metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            writer.writeAttribute(key, value, null);
        }
    }

    private void renderValidatorIds(FacesContext context, List<String> validatorIds) throws IOException {
        if (validatorIds == null || validatorIds.isEmpty()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < validatorIds.size(); ++i) {
            if (i != 0) {
                builder.append(',');
            }
            String validatorId = validatorIds.get(i);
            builder.append(validatorId);
        }
        writer.writeAttribute("data-p-val", (Object)builder.toString(), null);
    }

    protected String getHighlighter() {
        return null;
    }
}

