/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.expression.SearchExpressionResolverFactory;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchExpressionFacade {
    private static final Logger LOG = Logger.getLogger(SearchExpressionFacade.class.getName());
    private static final String SHARED_EXPRESSION_BUFFER_KEY = "SearchExpressionFacade.SHARED_EXPRESSION_BUFFER";
    private static final String SHARED_SPLIT_BUFFER_KEY = "SearchExpressionFacade.SHARED_SPLIT_BUFFER_KEY";
    private static final char[] EXPRESSION_SEPARATORS = new char[]{',', ' '};

    public static List<UIComponent> resolveComponents(FacesContext context, UIComponent source, String expressions) {
        String[] splittedExpressions;
        ArrayList<UIComponent> components = new ArrayList<UIComponent>();
        if (!ComponentUtils.isValueBlank(expressions) && (splittedExpressions = SearchExpressionFacade.split(context, expressions, EXPRESSION_SEPARATORS)) != null) {
            SearchExpressionFacade.validateExpressions(context, source, expressions, splittedExpressions);
            for (int i = 0; i < splittedExpressions.length; ++i) {
                UIComponent component;
                String expression = splittedExpressions[i].trim();
                if (ComponentUtils.isValueBlank(expression) || (component = SearchExpressionFacade.resolveComponent(context, source, expression)) == null) continue;
                components.add(component);
            }
        }
        return components;
    }

    public static String resolveComponentsForClient(FacesContext context, UIComponent source, String expressions) {
        return SearchExpressionFacade.resolveComponentsForClient(context, source, expressions, false);
    }

    public static String resolveComponentsForClient(FacesContext context, UIComponent source, String expressions, boolean checkForRenderer) {
        if (ComponentUtils.isValueBlank(expressions)) {
            return null;
        }
        String[] splittedExpressions = SearchExpressionFacade.split(context, expressions, EXPRESSION_SEPARATORS);
        String buildedExpressions = "";
        if (splittedExpressions != null) {
            SearchExpressionFacade.validateExpressions(context, source, expressions, splittedExpressions);
            StringBuilder expressionsBuffer = SearchExpressionFacade.getSharedBuffer(context, SHARED_EXPRESSION_BUFFER_KEY);
            for (int i = 0; i < splittedExpressions.length; ++i) {
                String component;
                String expression = splittedExpressions[i].trim();
                if (ComponentUtils.isValueBlank(expression)) continue;
                if (i != 0 && expressionsBuffer.length() > 0) {
                    expressionsBuffer.append(" ");
                }
                if ((component = SearchExpressionFacade.resolveComponentForClient(context, source, expression, checkForRenderer)) == null) continue;
                expressionsBuffer.append(component);
            }
            buildedExpressions = expressionsBuffer.toString();
        }
        if (ComponentUtils.isValueBlank(buildedExpressions)) {
            return null;
        }
        return buildedExpressions;
    }

    public static String resolveComponentsForClientWithParentFallback(FacesContext context, UIComponent source, String expressions) {
        if (ComponentUtils.isValueBlank(expressions)) {
            return source.getParent().getClientId(context);
        }
        return SearchExpressionFacade.resolveComponentsForClient(context, source, expressions, false);
    }

    public static String resolveComponentsForClientWithParentFallback(FacesContext context, UIComponent source, String expressions, boolean checkForRenderer) {
        if (ComponentUtils.isValueBlank(expressions)) {
            return source.getParent().getClientId(context);
        }
        return SearchExpressionFacade.resolveComponentsForClient(context, source, expressions, checkForRenderer);
    }

    public static String resolveComponentForClient(FacesContext context, UIComponent source, String expression) {
        return SearchExpressionFacade.resolveComponentForClient(context, source, expression, false);
    }

    public static String resolveComponentForClient(FacesContext context, UIComponent source, String expression, boolean checkForRenderer) {
        if (ComponentUtils.isValueBlank(expression)) {
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        String separatorString = String.valueOf(separatorChar);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar, separatorString);
        if (SearchExpressionFacade.isPassTroughExpression(expression)) {
            return expression;
        }
        UIComponent component = SearchExpressionFacade.resolveComponentInternal(context, source, expression, separatorChar, separatorString);
        if (component == null) {
            return null;
        }
        if (checkForRenderer && context.isProjectStage(ProjectStage.Development) && ComponentUtils.isValueBlank(component.getRendererType())) {
            LOG.warning("Can not update component without a attached renderer. Component class: \"" + component.getClass() + "\"");
        }
        return component.getClientId(context);
    }

    public static UIComponent resolveComponentWithParentFallback(FacesContext context, UIComponent source, String expression) {
        if (ComponentUtils.isValueBlank(expression)) {
            return source.getParent();
        }
        return SearchExpressionFacade.resolveComponent(context, source, expression);
    }

    public static UIComponent resolveComponent(FacesContext context, UIComponent source, String expression) {
        if (ComponentUtils.isValueBlank(expression)) {
            return null;
        }
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
        String separatorString = String.valueOf(separatorChar);
        expression = expression.trim();
        SearchExpressionFacade.validateExpression(context, source, expression, separatorChar, separatorString);
        if (expression.equals("@none")) {
            return null;
        }
        if (SearchExpressionFacade.isClientExpressionOnly(expression)) {
            throw new FacesException("Client side expression (PFS and @widgetVar) are not supported... Expression: " + expression);
        }
        UIComponent component = SearchExpressionFacade.resolveComponentInternal(context, source, expression, separatorChar, separatorString);
        if (component == null) {
            throw new FacesException("Cannot find component with expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
        }
        return component;
    }

    private static void validateExpression(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString) {
        if (context.isProjectStage(ProjectStage.Development)) {
            if (expression.startsWith(separatorString + "@")) {
                throw new FacesException("A expression should not start with the separater char and a keyword. Expression: \"" + expression + "\" from \"" + source.getClientId(context) + "\"");
            }
            String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
            if (subExpressions != null && subExpressions.length > 1) {
                for (int j = 0; j < subExpressions.length; ++j) {
                    String subExpression = subExpressions[j].trim();
                    if (SearchExpressionFacade.isNestable(subExpression)) continue;
                    throw new FacesException("Subexpression \"" + subExpression + "\" in full expression \"" + expression + "\" from \"" + source.getClientId(context) + "\" can not be nested.");
                }
            }
        }
    }

    private static void validateExpressions(FacesContext context, UIComponent source, String expressions, String[] splittedExpressions) {
        if (context.isProjectStage(ProjectStage.Development) && splittedExpressions.length > 1 && (expressions.contains("@none") || expressions.contains("@all"))) {
            throw new FacesException("It's not possible to use @none or @all combined with other expressions. Expressions: \"" + expressions + "\" referenced from \"" + source.getClientId(context) + "\"");
        }
    }

    private static UIComponent resolveComponentInternal(FacesContext context, UIComponent source, String expression, char separatorChar, String separatorString) {
        if (ComponentUtils.isValueBlank(expression)) {
            return null;
        }
        UIComponent component = null;
        if (expression.contains("@")) {
            if (expression.contains(separatorString)) {
                boolean startsWithSeperator;
                boolean bl = startsWithSeperator = expression.charAt(0) == separatorChar;
                if (startsWithSeperator) {
                    expression = expression.substring(1);
                }
                UIComponent last = source;
                String[] subExpressions = SearchExpressionFacade.split(context, expression, separatorChar);
                if (subExpressions != null) {
                    for (int j = 0; j < subExpressions.length; ++j) {
                        SearchExpressionResolver resolver;
                        UIComponent temp;
                        String subExpression = subExpressions[j].trim();
                        if (ComponentUtils.isValueBlank(subExpression)) continue;
                        if (startsWithSeperator && j == 0 && !subExpression.contains("@")) {
                            subExpression = separatorString + subExpression;
                        }
                        if ((temp = (resolver = SearchExpressionResolverFactory.findResolver(subExpression)).resolve(source, last, subExpression)) == null) {
                            throw new FacesException("Cannot find component for subexpression \"" + subExpression + "\" from component with id \"" + last.getClientId(context) + "\" in full expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                        }
                        last = temp;
                    }
                }
                component = last;
            } else {
                SearchExpressionResolver resolver = SearchExpressionResolverFactory.findResolver(expression);
                component = resolver.resolve(source, source, expression);
                if (component == null) {
                    throw new FacesException("Cannot find component for expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
                }
            }
        } else {
            component = source.findComponent(expression);
            if (component == null) {
                throw new FacesException("Cannot find component with expression \"" + expression + "\" referenced from \"" + source.getClientId(context) + "\".");
            }
        }
        return component;
    }

    private static String[] split(FacesContext context, String value, char ... separators) {
        char[] charArray;
        if (value == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buffer = SearchExpressionFacade.getSharedBuffer(context, SHARED_SPLIT_BUFFER_KEY);
        int parenthesesCounter = 0;
        for (char c : charArray = value.toCharArray()) {
            if (c == '(') {
                ++parenthesesCounter;
            }
            if (c == ')') {
                --parenthesesCounter;
            }
            if (parenthesesCounter == 0) {
                boolean isSeparator = false;
                for (char separator : separators) {
                    if (c != separator) continue;
                    isSeparator = true;
                }
                if (isSeparator) {
                    tokens.add(buffer.toString());
                    buffer.delete(0, buffer.length());
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        tokens.add(buffer.toString());
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean isPassTroughExpression(String expression) {
        return SearchExpressionFacade.isClientExpressionOnly(expression) || expression.contains("@all") || expression.contains("@none");
    }

    private static boolean isClientExpressionOnly(String expression) {
        return expression.contains("@(") || expression.contains("@widgetVar(");
    }

    private static boolean isNestable(String expression) {
        return !SearchExpressionFacade.isPassTroughExpression(expression);
    }

    private static StringBuilder getSharedBuffer(FacesContext context, String key) {
        StringBuilder buffer = (StringBuilder)context.getAttributes().get(key);
        if (buffer == null) {
            buffer = new StringBuilder();
            context.getAttributes().put(key, buffer);
        } else {
            buffer.setLength(0);
        }
        return buffer;
    }
}

