/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.omnifaces.util.Faces;

public final class Dates {
    private static final Map<Locale, Map<String, Integer>> MONTHS_CACHE = new HashMap<Locale, Map<String, Integer>>(3);
    private static final Map<Locale, Map<String, Integer>> SHORT_MONTHS_CACHE = new HashMap<Locale, Map<String, Integer>>(3);
    private static final Map<Locale, Map<String, Integer>> DAYS_OF_WEEK_CACHE = new HashMap<Locale, Map<String, Integer>>(3);
    private static final Map<Locale, Map<String, Integer>> SHORT_DAYS_OF_WEEK_CACHE = new HashMap<Locale, Map<String, Integer>>(3);
    private static final TimeZone TIMEZONE_DEFAULT = TimeZone.getDefault();
    private static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    private Dates() {
    }

    public static String formatDate(Date date, String pattern) {
        return Dates.formatDate(date, pattern, TIMEZONE_DEFAULT);
    }

    public static String formatDateWithTimezone(Date date, String pattern, Object timezone) {
        return Dates.formatDate(date, pattern, timezone instanceof TimeZone ? (TimeZone)timezone : TimeZone.getTimeZone(String.valueOf(timezone)));
    }

    private static String formatDate(Date date, String pattern, TimeZone timezone) {
        if (date == null) {
            return null;
        }
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Faces.getLocale());
        formatter.setTimeZone(timezone);
        return formatter.format(date);
    }

    public static Date addYears(Date date, int years) {
        return Dates.add(date, years, 1);
    }

    public static Date addMonths(Date date, int months) {
        return Dates.add(date, months, 2);
    }

    public static Date addWeeks(Date date, int weeks) {
        return Dates.add(date, weeks, 3);
    }

    public static Date addDays(Date date, int days) {
        return Dates.add(date, days, 5);
    }

    public static Date addHours(Date date, int hours) {
        return Dates.add(date, hours, 11);
    }

    public static Date addMinutes(Date date, int minutes) {
        return Dates.add(date, minutes, 12);
    }

    public static Date addSeconds(Date date, int seconds) {
        return Dates.add(date, seconds, 13);
    }

    private static Date add(Date date, int units, int field) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.setTimeZone(TIMEZONE_UTC);
        calendar.add(field, units);
        return calendar.getTime();
    }

    public static int yearsBetween(Date start, Date end) {
        return Dates.dateDiff(start, end, 1);
    }

    public static int monthsBetween(Date start, Date end) {
        return Dates.dateDiff(start, end, 2);
    }

    public static int weeksBetween(Date start, Date end) {
        return Dates.dateDiff(start, end, 3);
    }

    public static int daysBetween(Date start, Date end) {
        return Dates.dateDiff(start, end, 5);
    }

    private static int dateDiff(Date startDate, Date endDate, int field) {
        int elapsed;
        block5: {
            Calendar end;
            Calendar start;
            block4: {
                if (startDate == null) {
                    throw new NullPointerException("start");
                }
                if (endDate == null) {
                    throw new NullPointerException("end");
                }
                start = Dates.toUTCCalendarWithoutTime(startDate);
                end = Dates.toUTCCalendarWithoutTime(endDate);
                elapsed = 0;
                if (!start.before(end)) break block4;
                while (start.before(end)) {
                    start.add(field, 1);
                    ++elapsed;
                }
                break block5;
            }
            if (!start.after(end)) break block5;
            while (start.after(end)) {
                start.add(field, -1);
                --elapsed;
            }
        }
        return elapsed;
    }

    private static Calendar toUTCCalendarWithoutTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static long hoursBetween(Date start, Date end) {
        return Dates.timeDiff(start, end, TimeUnit.HOURS);
    }

    public static long minutesBetween(Date start, Date end) {
        return Dates.timeDiff(start, end, TimeUnit.MINUTES);
    }

    public static long secondsBetween(Date start, Date end) {
        return Dates.timeDiff(start, end, TimeUnit.SECONDS);
    }

    private static long timeDiff(Date startDate, Date endDate, TimeUnit timeUnit) {
        if (startDate == null) {
            throw new NullPointerException("start");
        }
        if (endDate == null) {
            throw new NullPointerException("end");
        }
        return timeUnit.convert(endDate.getTime() - startDate.getTime(), TimeUnit.MILLISECONDS);
    }

    public static Map<String, Integer> getMonths() {
        Locale locale = Faces.getLocale();
        Map<String, Integer> months = MONTHS_CACHE.get(locale);
        if (months == null) {
            months = Dates.mapMonths(DateFormatSymbols.getInstance(Faces.getLocale()).getMonths());
            MONTHS_CACHE.put(locale, months);
        }
        return months;
    }

    public static Map<String, Integer> getShortMonths() {
        Locale locale = Faces.getLocale();
        Map<String, Integer> shortMonths = SHORT_MONTHS_CACHE.get(locale);
        if (shortMonths == null) {
            shortMonths = Dates.mapMonths(DateFormatSymbols.getInstance(Faces.getLocale()).getShortMonths());
            SHORT_MONTHS_CACHE.put(locale, shortMonths);
        }
        return shortMonths;
    }

    private static Map<String, Integer> mapMonths(String[] months) {
        LinkedHashMap<String, Integer> mapping = new LinkedHashMap<String, Integer>();
        for (String month : months) {
            if (month.isEmpty()) continue;
            mapping.put(month, mapping.size() + 1);
        }
        return mapping;
    }

    public static Map<String, Integer> getDaysOfWeek() {
        Locale locale = Faces.getLocale();
        Map<String, Integer> daysOfWeek = DAYS_OF_WEEK_CACHE.get(locale);
        if (daysOfWeek == null) {
            daysOfWeek = Dates.mapDaysOfWeek(DateFormatSymbols.getInstance(Faces.getLocale()).getWeekdays());
            DAYS_OF_WEEK_CACHE.put(locale, daysOfWeek);
        }
        return daysOfWeek;
    }

    public static Map<String, Integer> getShortDaysOfWeek() {
        Locale locale = Faces.getLocale();
        Map<String, Integer> shortDaysOfWeek = SHORT_DAYS_OF_WEEK_CACHE.get(locale);
        if (shortDaysOfWeek == null) {
            shortDaysOfWeek = Dates.mapDaysOfWeek(DateFormatSymbols.getInstance(Faces.getLocale()).getShortWeekdays());
            SHORT_DAYS_OF_WEEK_CACHE.put(locale, shortDaysOfWeek);
        }
        return shortDaysOfWeek;
    }

    private static Map<String, Integer> mapDaysOfWeek(String[] weekdays) {
        LinkedHashMap<String, Integer> mapping = new LinkedHashMap<String, Integer>();
        mapping.put(weekdays[2], 1);
        mapping.put(weekdays[3], 2);
        mapping.put(weekdays[4], 3);
        mapping.put(weekdays[5], 4);
        mapping.put(weekdays[6], 5);
        mapping.put(weekdays[7], 6);
        mapping.put(weekdays[1], 7);
        return mapping;
    }

    public static String getMonth(Integer monthNumber) {
        return Dates.getKey(Dates.getMonths(), monthNumber);
    }

    public static String getShortMonth(Integer monthNumber) {
        return Dates.getKey(Dates.getShortMonths(), monthNumber);
    }

    public static String getDayOfWeek(Integer dayOfWeekNumber) {
        return Dates.getKey(Dates.getDaysOfWeek(), dayOfWeekNumber);
    }

    public static String getShortDayOfWeek(Integer dayOfWeekNumber) {
        return Dates.getKey(Dates.getShortDaysOfWeek(), dayOfWeekNumber);
    }

    private static <K, V> K getKey(Map<K, V> map, V value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

