/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.omnifaces.component.validator.ValidateMultipleFields;
import org.omnifaces.util.Callback;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.validator.ValidateOrder")
public class ValidateOrder
extends ValidateMultipleFields {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.validator.ValidateOrder";
    private static final String DEFAULT_TYPE = Type.LT.name();
    private static final String DEFAULT_MESSAGE = "{0}: Please fill out the values of all those fields in order";
    private static final String ERROR_INVALID_TYPE = "Invalid type '%s'. Only 'lt', 'lte', 'gt' and 'gte' are allowed.";
    private static final String ERROR_VALUES_NOT_COMPARABLE = "All values must implement java.lang.Comparable.";
    private final State state = new State(this.getStateHelper());

    public ValidateOrder() {
        super(DEFAULT_MESSAGE);
    }

    @Override
    public boolean validateValues(FacesContext context, List<UIInput> components, List<Object> values) {
        try {
            List<Object> tmp = values;
            return Type.valueOf(this.getType().toUpperCase()).validateOrder(tmp);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(ERROR_VALUES_NOT_COMPARABLE, e);
        }
    }

    public String getType() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.type), DEFAULT_TYPE);
    }

    public void setType(String type) {
        try {
            Type.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_TYPE, type), e);
        }
        this.state.put((Serializable)((Object)PropertyKeys.type), type);
    }

    private static enum PropertyKeys {
        type;

    }

    private static enum Type {
        LT(new Callback.ReturningWithArgument<Boolean, List<Comparable>>(){

            @Override
            public Boolean invoke(List<Comparable> values) {
                return new ArrayList<Comparable>(Utils.nullSafeTreeSet(values)).equals(values);
            }
        }),
        LTE(new Callback.ReturningWithArgument<Boolean, List<Comparable>>(){

            @Override
            public Boolean invoke(List<Comparable> values) {
                ArrayList<Comparable> sortedValues = new ArrayList<Comparable>(values);
                Collections.sort(sortedValues);
                return sortedValues.equals(values);
            }
        }),
        GT(new Callback.ReturningWithArgument<Boolean, List<Comparable>>(){

            @Override
            public Boolean invoke(List<Comparable> values) {
                ArrayList<Comparable> sortedValues = new ArrayList<Comparable>(Utils.nullSafeTreeSet(values));
                Collections.reverse(sortedValues);
                return sortedValues.equals(values);
            }
        }),
        GTE(new Callback.ReturningWithArgument<Boolean, List<Comparable>>(){

            @Override
            public Boolean invoke(List<Comparable> values) {
                ArrayList<Comparable> sortedValues = new ArrayList<Comparable>(values);
                Collections.sort(sortedValues, Collections.reverseOrder());
                return sortedValues.equals(values);
            }
        });

        private Callback.ReturningWithArgument<Boolean, List<Comparable>> callback;

        private Type(Callback.ReturningWithArgument<Boolean, List<Comparable>> callback) {
            this.callback = callback;
        }

        public boolean validateOrder(List<Comparable> values) {
            return this.callback.invoke(values);
        }
    }
}

