/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.viewscope;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import org.omnifaces.cdi.ViewScoped;
import org.omnifaces.cdi.viewscope.ViewScopeManager;
import org.omnifaces.util.Beans;

public class ViewScopeContext
implements Context {
    private BeanManager manager;
    private Bean<ViewScopeManager> bean;
    private ViewScopeManager viewScopeManager;

    public ViewScopeContext(BeanManager manager, Bean<ViewScopeManager> bean) {
        this.manager = manager;
        this.bean = bean;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context != null && context.getViewRoot() != null && this.isInitialized();
    }

    public <T> T get(Contextual<T> type) {
        this.checkActive();
        return this.viewScopeManager.getBean(type);
    }

    public <T> T get(Contextual<T> type, CreationalContext<T> context) {
        this.checkActive();
        T bean = this.viewScopeManager.getBean(type);
        return bean != null ? bean : this.viewScopeManager.createBean(type, context);
    }

    private boolean isInitialized() {
        if (this.viewScopeManager == null) {
            this.viewScopeManager = Beans.getReference(this.manager, this.bean);
        }
        return this.viewScopeManager != null;
    }

    private void checkActive() throws ContextNotActiveException {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
    }
}

