/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.application.Resource;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

final class CombinedResourceInputStream
extends InputStream {
    private List<InputStream> streams = new ArrayList<InputStream>();
    private Iterator<InputStream> streamIterator;
    private InputStream currentStream;

    public CombinedResourceInputStream(Set<Resource> resources) throws IOException {
        for (Resource resource : resources) {
            this.streams.add(!Hacks.isRichFacesResourceOptimizationEnabled() ? resource.getInputStream() : new URL(Faces.getRequestDomainURL() + resource.getRequestPath()).openStream());
        }
        this.streamIterator = this.streams.iterator();
        this.streamIterator.hasNext();
        this.currentStream = this.streamIterator.next();
    }

    @Override
    public int read() throws IOException {
        int read = -1;
        while ((read = this.currentStream.read()) == -1 && this.streamIterator.hasNext()) {
            this.currentStream = this.streamIterator.next();
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        IOException caught = null;
        for (InputStream stream : this.streams) {
            IOException e = Utils.close(stream);
            if (caught != null) continue;
            caught = e;
        }
        if (caught != null) {
            throw caught;
        }
    }
}

